(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    144962,       4248]*)
(*NotebookOutlinePosition[    147014,       4312]*)
(*  CellTagsIndexPosition[    146881,       4304]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Teoremas de Stokes y de Gauss
Funciones arm\[OAcute]nicas\
\>", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  FontSize->12],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell[BoxData[{
    \(Off[ParametricPlot3D::ppcom]\), "\n", 
    \(Off[ParametricPlot::ppcom]\), "\n", 
    \(Off[General::spell]\), "\[IndentingNewLine]", 
    \(Off[General::spell1]\)}], "Input",
  InitializationCell->True],

Cell["<<Graphics`Arrow`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell["<<Graphics`Colors`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell[BoxData[{
    \(norma[x_] := N[\@\(x . x\)]\  (*\ 
      norma\ eucl\[IAcute]dea\ del\ vector\ x\ *) \), "\n", 
    \(\(normaliza[x_]\  := If[Simplify[x . x] == 0, x, \ x/norma[x]];\)\  (*\ 
      vector\ unitario\ en\ la\ direcci\[OAcute]n\ del\ vector\ x\ *) \), "\n\
", 
    \(vector2D[x_: {0, 0}, y_] := 
      Arrow[x, x + y]\ \), "\[IndentingNewLine]", 
    \(normal3D[x_]\  := \ 
      normaliza[
        Which[x[\([1]\)] == 0, {1, 0, 
            0}, \((x[\([2]\)] \[NotEqual] 
                0)\) \[Or] \((x[\([3]\)] \[NotEqual] 0)\), {0, 
            x[\([3]\)], \(-x[\([2]\)]\)}, \((x[\([2]\)] == 0 \[And] 
              x[\([3]\)] == 0)\), {0, 1, 0}]]\), "\n", 
    \( (*\ un\ vector\ unitario\ ortogonal\ al\ vector\ x\ *) \)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(\(arrow3D[x_, y_, color_:  RGBColor[0. , 0. , 0. ], 
          grosor_:  0.007] := \n\t\t\t{{color, Thickness[grosor], 
            Line[{x, y}]}, \n\ \ \ \ \ {SurfaceColor[
              color], \ \(Polygon[
                  Append[#, 
                    y]] &\)\  /@ \ \n\t\t\t\t\t\tPartition[\(\((y\ \  - \ 
                        0.18*\((y - x)\) + \ #)\) &\) /@ \((\((0.3*\ 0.18*
                          norma[y - x]*\ 
                          Table[{Cos[2\ k\ Pi/8. ], \ Sin[2\ k\ Pi/8. ]}, {k, 
                              0, 8}])\) . {normal3D[y - x], 
                        normaliza[Cross[normal3D[y - x], y - x]]})\), 2, 
                1]}};\)\n
    vector3D[x_List: {0, 0, 0}, y_List, color_:  RGBColor[0. , 0. , 0. ], 
        grosor_:  0.007] := arrow3D[x, x + y, color, grosor]\)\(\ \)\( (*\ 
      traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x\ *) \)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(\(tgtunit[func_, 
          t_] = \(func'\)[t]\/\@\(\(func'\)[t] . \(func'\)[t]\);\)\), "\n", 
    \(normalunit[func_, t_] := 
      Module[{s}, normaliza[D[tgtunit[func, s], s]] /. s -> t]\)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    StyleBox[\(gramschmidt = 
          Fold[Append[#1, \((#1\/\@\(#1 . #1\) &)\)[
                    Fold[#1 - #1 . #2\ #2\  &, #2, #1]]] &, {}, #1] &;\),
      FontFamily->"Courier New"]], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(semiesferasuperior := 
      Module[{fig1, fig2, normales, tangentes, normalesinteriores, 
          f, \[Gamma], n}, 
        f[s_, t_] = 
          4 {Cos[t]*Sin[s], Sin[t]*Sin[s], Cos[s]}; \[IndentingNewLine]fig1 = 
          ParametricPlot3D[
            4 {Cos[t]*Sin[s], Sin[t]*Sin[s], Cos[s]}, {t, 0, 2  \[Pi]}, {s, 
              0, \[Pi]/2}, AspectRatio \[Rule] Automatic, Axes \[Rule] False, 
            Boxed \[Rule] False, 
            ViewPoint -> {1.536, \ \(-2.836\), \ \(-1.025\)}, 
            DisplayFunction \[Rule] Identity]; \[IndentingNewLine]fig2 = 
          ParametricPlot3D[{3.9  Cos[t], 3.9  Sin[t], 
              0, {Yellow, Thickness[0.007]}}, {t, 0, 2  \[Pi]}, 
            Boxed \[Rule] False, Ticks \[Rule] None, Axes \[Rule] False, 
            DisplayFunction \[Rule] Identity]; \[IndentingNewLine]n[s_, t_] = 
          Simplify[
            Cross[D[f[s, t], s], D[f[s, t], t]]\/\@\(Cross[D[f[s, t], s], \
D[f[s, t], t]] . Cross[D[f[s, t], s], D[f[s, t], t]]\), 
            Sin[s] > 0]; \[IndentingNewLine]normales = 
          Graphics3D[
            Table[vector3D[f[s, t], n[s, t], Green], {t, 0. , 2  \[Pi], 
                  N[\[Pi]]/6}, {s, 0. , \[Pi]/2, N[\[Pi]/2]/3}] // 
              Chop]; \n\[Gamma][t_] = {4  Cos[t], 4  Sin[t], 0}; \n
        tangentes = 
          Graphics3D[
            Table[vector3D[\[Gamma][t], tgtunit[\[Gamma], t], Blue], {t, 0. , 
                  2  \[Pi], N[\[Pi]]/6}] // Chop]; \n
        normalesinteriores = 
          Graphics3D[
            Table[vector3D[\[Gamma][t], 
                  Cross[n[\[Pi]/2. , t], tgtunit[\[Gamma], t]], Red], {t, 
                  0. , 2  \[Pi], N[\[Pi]]/6}] // 
              Chop]; \[IndentingNewLine]Show[{fig1, fig2, normales, 
            tangentes, normalesinteriores}, 
          DisplayFunction \[Rule] $DisplayFunction]; \[IndentingNewLine] (*\ 
          Table[Det[{tgtunit[\[Gamma], t], 
                  Cross[n[\[Pi]/2. , t], tgtunit[\[Gamma], t]], 
                  n[\[Pi]/2. , t]}], {t, 0. , 2  \[Pi], N[\[Pi]]/6}] // 
            Chop\ *) ]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(semiesferainferior := 
      Module[{fig1, fig2, normales, tangentes, normalesinteriores, 
          f, \[Gamma], n}, 
        f[s_, t_] = 
          4 {Cos[t]*Sin[s], Sin[t]*Sin[s], Cos[s]}; \[IndentingNewLine]fig1 = 
          ParametricPlot3D[
            4 {Cos[t]*Sin[s], Sin[t]*Sin[s], Cos[s]}, {t, 0, 
              2  \[Pi]}, {s, \[Pi]/2, \[Pi]}, AspectRatio \[Rule] Automatic, 
            Axes \[Rule] False, Boxed \[Rule] False, 
            DisplayFunction \[Rule] Identity]; \[IndentingNewLine]fig2 = 
          ParametricPlot3D[{3.9  Cos[t], 3.9  Sin[t], 
              0, {Yellow, Thickness[0.007]}}, {t, 0, 2  \[Pi]}, 
            Boxed \[Rule] False, Ticks \[Rule] None, Axes \[Rule] False, 
            DisplayFunction \[Rule] Identity]; \[IndentingNewLine]n[s_, t_] = 
          Simplify[
            Cross[D[f[s, t], s], 
                D[f[s, t], 
                  t]]/\((\[Sqrt]\((Cross[D[f[s, t], s], D[f[s, t], t]] . 
                      Cross[D[f[s, t], s], D[f[s, t], t]])\))\), 
            Sin[s] > 0]; \[IndentingNewLine]normales = 
          Graphics3D[
            Table[vector3D[f[s, t], n[s, t], Green], {t, 0. , 2  \[Pi], 
                  N[\[Pi]]/6}, {s, N[\[Pi]/2], N[\[Pi]], N[\[Pi]/2]/4}] // 
              Chop]; \n\[Gamma][t_] = {4  Cos[t], 4  Sin[t], 0}; \n
        tangentes = 
          Graphics3D[
            Table[vector3D[\[Gamma][t], \(-tgtunit[\[Gamma], t]\), Blue], {t, 
                  0. , 2  \[Pi], N[\[Pi]]/6}] // Chop]; \n
        normalesinteriores = 
          Graphics3D[
            Table[vector3D[\[Gamma][
                    t], \(-Cross[n[\[Pi]/2. , t], tgtunit[\[Gamma], t]]\), 
                  Red], {t, 0. , 2  \[Pi], N[\[Pi]]/6}] // 
              Chop]; \[IndentingNewLine]Show[{fig1, fig2, normales, 
            tangentes, normalesinteriores}, 
          DisplayFunction \[Rule] $DisplayFunction]; \[IndentingNewLine] (*\ 
          Table[Det[{\(-tgtunit[\[Gamma], t]\), 
                  Cross[n[\[Pi]/2. , t], \(-tgtunit[\[Gamma], t]\)], 
                  n[\[Pi]/2. , t]}], {t, 0. , 2  \[Pi], N[\[Pi]]/6}] // 
            Chop\ *) ]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(cilindro := 
        Module[{fig1, fig2, fig3, normales, tangentes1, normalinterior1, 
            tangentes2, normalinterior2, f, \[Gamma]1, \[Gamma]2, n}, 
          f[s_, t_] = {t, Cos[s], Sin[s]}; \[IndentingNewLine]fig1 = 
            ParametricPlot3D[{t, Cos[s], Sin[s]}, {s, 0, 2  \[Pi]}, {t, 1, 
                4}, AspectRatio \[Rule] Automatic, Axes \[Rule] False, 
              Boxed \[Rule] False, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]fig2 = 
            ParametricPlot3D[{1, Cos[t], 
                Sin[t], {Yellow, Thickness[0.007]}}, {t, 0, 2  \[Pi]}, 
              Boxed \[Rule] False, Ticks \[Rule] None, Axes \[Rule] False, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]fig3 = 
            ParametricPlot3D[{4, Cos[t], 
                Sin[t], {Yellow, Thickness[0.007]}}, {t, 0, 2  \[Pi]}, 
              Boxed \[Rule] False, Ticks \[Rule] None, Axes \[Rule] False, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]n[t_, 
              s_] = Simplify[
              Cross[D[f[s, t], s], 
                  D[f[s, t], 
                    t]]/\[Sqrt]\((Cross[D[f[s, t], s], D[f[s, t], t]] . 
                      Cross[D[f[s, t], s], 
                        D[f[s, t], t]])\)]; \[IndentingNewLine]normales = 
            Graphics3D[
              Table[vector3D[f[\[Pi], t], n[t, \[Pi]], Green], {t, 1. , 4. , 
                    1.5}] // Chop]; \n\[Gamma]1[t_] = {1, Cos[t], Sin[t]}; \n
          tangentes1 = 
            Graphics3D[
              vector3D[\[Gamma]1[\[Pi]], tgtunit[\[Gamma]1, \[Pi]], Blue]]; \n
          normalinterior1 = 
            Graphics3D[
              vector3D[\[Gamma]1[\[Pi]], \(-Cross[n[\[Pi], 1. ], 
                    tgtunit[\[Gamma]1, \[Pi]]]\), 
                Red]]; \[IndentingNewLine]\[Gamma]2[t_] = {4, Cos[t], 
              Sin[t]}; \n
          tangentes2 = 
            Graphics3D[
              vector3D[\[Gamma]2[\[Pi]], \(-tgtunit[\[Gamma]2, \[Pi]]\), 
                Blue]]; \n
          normalinterior2 = 
            Graphics3D[
              vector3D[\[Gamma]2[\[Pi]], 
                Cross[n[4. , \[Pi]], \(-tgtunit[\[Gamma]2, \[Pi]]\)], 
                Red]]; \[IndentingNewLine]Show[{fig1, fig2, fig3, normales, 
              tangentes1, normalinterior1, tangentes2, normalinterior2}, 
            DisplayFunction \[Rule] $DisplayFunction]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(casquete := 
        Module[{fig1, fig2, normal, normal2, tangente, normalinterior, 
            f, \[Gamma]}, 
          f[\[Theta]_, \[Phi]_] = {Cos[\[Phi]] Sin[\[Theta]], 
              Sin[\[Phi]] Sin[\[Theta]], 
              1 + Cos[\[Theta]]}; \[IndentingNewLine]fig1 = 
            ParametricPlot3D[{Cos[\[Phi]] Sin[\[Theta]], 
                Sin[\[Phi]] Sin[\[Theta]], 1 + Cos[\[Theta]]}, {\[Phi], 0, 
                2  \[Pi]}, {\[Theta], 0, ArcCos[3. /5]}, Boxed \[Rule] False, 
              Axes \[Rule] False, AspectRatio \[Rule] 1, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]fig2 = 
            ParametricPlot3D[{Cos[\[Phi]] 4/5, Sin[\[Phi]] 4/5, 
                8/5, {Yellow, Thickness[0.007]}}, {\[Phi], 0, 2  \[Pi]}, 
              Boxed \[Rule] False, Axes \[Rule] False, AspectRatio \[Rule] 1, 
              DisplayFunction \[Rule] 
                Identity]; \[IndentingNewLine]\[Gamma][\[Phi]_] = \
{Cos[\[Phi]] 4/5, Sin[\[Phi]] 4/5, 8/5}; \[IndentingNewLine]n[s_, t_] = 
            Simplify[
              Cross[D[f[s, t], s], 
                  D[f[s, t], 
                    t]]/\[Sqrt]\((Cross[D[f[s, t], s], D[f[s, t], t]] . 
                      Cross[D[f[s, t], s], 
                        D[f[s, t], t]])\)]; \[IndentingNewLine]normal = 
            Graphics3D[
              vector3D[f[ArcCos[3. /5], 3  \[Pi]/2], 
                n[ArcCos[3. /5], 3  \[Pi]/2], 
                Green]]; \[IndentingNewLine]normal2 = 
            Graphics3D[vector3D[{0, 0, 2},  .5 {0, 0, 1}, Green]]; \n
          tangente = 
            Graphics3D[
              vector3D[\[Gamma][3  \[Pi]/2],  .5 
                   tgtunit[\[Gamma], 3  \[Pi]/2], Blue]]; \n
          normalinterior = 
            Graphics3D[
              vector3D[\[Gamma][3  \[Pi]/2],  .5 
                   Cross[n[ArcCos[3. /5], 3  \[Pi]/2], 
                    tgtunit[\[Gamma], 3  \[Pi]/2]], 
                Red]]; \[IndentingNewLine]Show[{fig1, fig2, normal, normal2, 
              tangente, normalinterior}, 
            DisplayFunction \[Rule] $DisplayFunction, 
            PlotRange \[Rule] All]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(cono := 
        Module[{fig1, fig2, normal, normal2, tangente, normalinterior, 
            f, \[Gamma]}, 
          f[\[Rho]_, \[Phi]_] = {\[Rho]*Cos[\[Phi]], \[Rho]*Sin[\[Phi]], 
              2  \[Rho]}; \[IndentingNewLine]fig1 = 
            ParametricPlot3D[{\[Rho]*Cos[\[Phi]], \[Rho]*Sin[\[Phi]], 
                2  \[Rho]}, {\[Phi], 0, 2  \[Pi]}, {\[Rho], 0, 4/5}, 
              Boxed \[Rule] False, Axes \[Rule] False, AspectRatio \[Rule] 1, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]fig2 = 
            ParametricPlot3D[{Cos[\[Phi]] 4/5, Sin[\[Phi]] 4/5, 
                8/5, {Yellow, Thickness[0.007]}}, {\[Phi], 0, 2  \[Pi]}, 
              Boxed \[Rule] False, Axes \[Rule] False, AspectRatio \[Rule] 1, 
              DisplayFunction \[Rule] 
                Identity]; \[IndentingNewLine]\[Gamma][\[Phi]_] = \
{Cos[\[Phi]] 4/5, Sin[\[Phi]] 4/5, 8/5}; \[IndentingNewLine]n[s_, t_] = 
            Simplify[
              Cross[D[f[s, t], s], 
                  D[f[s, t], 
                    t]]/\[Sqrt]\((Cross[D[f[s, t], s], D[f[s, t], t]] . 
                      Cross[D[f[s, t], s], 
                        D[f[s, t], t]])\)]; \[IndentingNewLine]normal = 
            Graphics3D[
              vector3D[f[4/5, 3  \[Pi]/2], \(- .5\) n[4/5, 3  \[Pi]/2], 
                Green]]; \[IndentingNewLine]normal2 = 
            Graphics3D[
              vector3D[
                f[3/5. , \(-\[Pi]\)/3. ], \(- .5\) n[3/5. , \(-\[Pi]\)/3. ], 
                Green]]; \n
          tangente = 
            Graphics3D[
              vector3D[\[Gamma][3  \[Pi]/2], \(- .5\) 
                  tgtunit[\[Gamma], 3  \[Pi]/2], Blue]]; \n
          normalinterior = 
            Graphics3D[
              vector3D[\[Gamma][3  \[Pi]/2],  .5 
                   Cross[n[ArcCos[3. /5], 3  \[Pi]/2], 
                    tgtunit[\[Gamma], 3  \[Pi]/2]], 
                Red]]; \[IndentingNewLine]Show[{fig1, fig2, normal, normal2, 
              tangente, normalinterior}, 
            DisplayFunction \[Rule] $DisplayFunction, 
            PlotRange \[Rule] All]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(helado := Show[casquete, cono]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{"molinillo", ":=", 
      RowBox[{"Module", "[", 
        RowBox[{\({fig1, fig2, fig3, texto}\), ",", 
          
          RowBox[{\(fig1 = 
              Graphics[{Thickness[ .007], Circle[{0, 0}, 1], 
                  Line[{{\(-1\), 0}, {1, 0}}], PointSize[ .07], 
                  Point[{0, 0}], PointSize[ .03], Red, Point[{1, 0}], 
                  Point[{\(-1\), 0}]}]\), ";", 
            "\[IndentingNewLine]", \(fig2 = 
              Graphics[{vector2D[{1, 0}, {1.2, 1.2}], 
                  vector2D[{\(-1\), 0}, { .8,  .6}]}]\), ";", 
            "\[IndentingNewLine]", 
            RowBox[{"texto", "=", 
              RowBox[{"Graphics", "[", 
                RowBox[{"{", 
                  
                  RowBox[{\(Text[\*"\"\<\!\(p\_1\)\>\"", {1.2, 0}]\), 
                    ",", \(Text[\*"\"\<\!\(p\_2\)\>\"", {\(-1.2\), 0}]\), ",",
                     
                    RowBox[{"Text", "[", 
                      RowBox[{"\"\<\!\(\(\*
StyleBox[\"v\",\nFontSlant->\"Italic\"]\)\_1\)\>\"", ",", \({1, 1.35}\)}], 
                      "]"}], ",", 
                    RowBox[{"Text", "[", 
                      RowBox[{"\"\<\!\(\(\*
StyleBox[\"v\",\nFontSlant->\"Italic\"]\)\_2\)\>\"", 
                        ",", \({\(-1\), 0.73}\)}], "]"}], 
                    ",", \(Text[\*"\"\<V(\!\(p\_1\))\>\"", {2.1,  .75}]\), 
                    ",", \(Text[\*"\"\<V(\!\(p\_2\))\>\"", {\(- .2\), 
                        0.35}]\)}], "}"}], "]"}]}], ";", 
            "\[IndentingNewLine]", \(fig3 = 
              Graphics[{vector2D[{1, 0}, {0, 1.2}], 
                  vector2D[{\(-1\), 0}, {0,  .6}]}]\), ";", 
            "\[IndentingNewLine]", \(Show[{fig1, fig2, fig3, texto}, 
              Ticks \[Rule] None, Axes \[Rule] False, 
              AspectRatio \[Rule] Automatic, PlotRange \[Rule] All, 
              TextStyle \[Rule] {FontFamily -> "\<Times\>", 
                  FontSize -> "\<12\>", FontWeight -> "\<Bold\>"}]\)}]}], 
        "]"}]}]], "Input",
  InitializationCell->True],

Cell["<<Graphics`Animation`", "Input",
  InitializationCell->True,
  CellTags->"S5.29.1"],

Cell["<<Calculus`VectorAnalysis`", "Input",
  InitializationCell->True,
  CellTags->"S5.16.1"],

Cell[BoxData[
    \(On[General::spell]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Teorema de Stokes", "Section"],

Cell[TextData[{
  "El teorema de Stokes es una generalizaci\[OAcute]n del teorema de Green \
para superficies en el espacio: el teorema de Green establece una igualdad \
entre integrales dobles e integrales de l\[IAcute]nea y el teorema de Stokes \
establece una igualdad entre integrales de superficie e integrales de l\
\[IAcute]nea. Veremos que en el caso particular de que la superficie sea una \
superficie plana situada en el plano XY con normal unitaria igual a ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          FontWeight->"Bold"], TraditionalForm]]],
  " el teorema de Stokes se convierte en el teorema de Green."
}], "Text"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{"S", Cell[""]}], TraditionalForm]]],
  "una superficie que suponemos orientada por un campo continuo de vectores \
que a cada punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Element] S\)]],
  " hace corresponder un vector unitario normal a ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " que notaremos ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], TraditionalForm]]],
  ". Suponemos que la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " es una superficie abierta y representamos por ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " su \"borde\". Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " puede ser una curva cerrada o puede estar formado por varias curvas \
cerradas disjuntas (por ejemplo, la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " puede ser un trozo de cilindro circular recto sin tapaderas en cuyo caso \
su borde son dos circunferencias).  "
}], "Text"],

Cell[TextData[{
  " La orientaci\[OAcute]n en ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " definida por el campo de vectores normales ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold"], 
          StyleBox["(",
            FontWeight->"Plain"], 
          StyleBox[\(x, y, z\),
            FontWeight->"Plain"], 
          StyleBox[")",
            FontWeight->"Plain"]}], TraditionalForm]]],
  " induce una orientaci\[OAcute]n en ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " que se llama ",
  StyleBox["orientaci\[OAcute]n inducida",
    FontWeight->"Bold"],
  ".",
  " En t\[EAcute]rminos familiares, la orientaci\[OAcute]n inducida en ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " es aquella en la que al recorrer caminando ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " en el sentido que indica el vector tangente en cada punto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " y con la cabeza apuntando en el sentido que indica el vector normal ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          FontWeight->"Bold"], TraditionalForm]]],
  ", la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " queda a nuestra izquierda."
}], "Text"],

Cell[TextData[{
  " Una definici\[OAcute]n matem\[AAcute]tica m\[AAcute]s precisa de lo que \
se entiende por \"orientaci\[OAcute]n inducida\" es la siguiente. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`P \[Element] \[PartialD]S\)]],
  " un punto en el borde de la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". La \"curva\" ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " tiene en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " dos vectores normales unitarios que son tangentes a la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  "; estos vectores son opuestos entre s\[IAcute]. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " uno de dichos vectores. Representemos por ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " el plano tangente a ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  ". Sea ",
  Cell[BoxData[
      \(TraditionalForm\`B(P, \[Epsilon])\)]],
  " una bola centrada en ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(P\)\(\ \)\)\)]],
  "de radio ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] > 0\)]],
  " suficientemente peque\[NTilde]o. Definamos ",
  Cell[BoxData[
      \(TraditionalForm\`G = B(P, \[Epsilon]) \[Intersection] \ S\)]],
  " y sea ",
  Cell[BoxData[
      \(TraditionalForm\`D = \(\[CapitalPi]\_H\)(G)\)]],
  " la proyecci\[OAcute]n ortogonal de ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " sobre ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ". Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPi]\_H\)]],
  " deja invariante a ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " y a ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " porque ambos est\[AAcute]n en ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ". Adem\[AAcute]s, como ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPi]\_H\)]],
  " conserva la ortogonalidad, el vector ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " es normal en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " a la curva ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[PartialD]S)\)\_H = \(\[CapitalPi]\_H\)(\
\[PartialD]S \[Intersection] B(P, \[Epsilon]))\)]],
  ". Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " es un dominio plano y que ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[PartialD]S)\)\_H\)]],
  " es parte de ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]D\)]],
  ". Pues bien, si el vector ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " es la normal interior a ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]D\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " (en el sentido que definimos al estudiar el teorema de Green) se dice que \
",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " es el vector unitario normal a ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " que ",
  StyleBox["apunta hacia dentro",
    FontWeight->"Bold"],
  " de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ".  ",
  StyleBox["La orientaci\[OAcute]n inducida en ",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  StyleBox[" por la orientaci\[OAcute]n dada de la superficie",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " es aquella en la que, notando por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["N",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], TraditionalForm]]],
  " el vector unitario normal a  ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " que apunta hacia dentro de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " y por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["T",
            FontWeight->"Bold"], 
          StyleBox["(",
            FontWeight->"Plain"], 
          StyleBox[\(x, y, z\),
            FontWeight->"Plain"], 
          StyleBox[")",
            FontWeight->"Plain"]}], TraditionalForm]]],
  " el vector tangente unitario a ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Element] \[PartialD]S\)]],
  ", se verifica que la base ortonormal ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}], ",", 
            RowBox[{
              StyleBox["N",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}], ",", 
            RowBox[{
              StyleBox["n",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}]}], "}"}], 
        TraditionalForm]]],
  " ",
  StyleBox["tiene determinante positivo (",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{"de", " ", "hecho", " ", "igual", " ", 
          StyleBox["a",
            FontSlant->"Plain"], " ", "1"}], TraditionalForm]]],
  StyleBox[") para todo ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Element] \[PartialD]S\)]],
  ". Observa que, cualquiera sea el vector tangente unitario ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["T",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], TraditionalForm]]],
  " se tiene que ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["N",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
            RowBox[{
              RowBox[{
                StyleBox["n",
                  FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "\[Times]", 
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold"], "(", \(x, y, z\), ")"}]}]}]}], 
        TraditionalForm]]],
  " o ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["N",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
            RowBox[{
              RowBox[{"-", 
                RowBox[{
                  StyleBox["n",
                    FontWeight->"Bold"], "(", \(x, y, z\), ")"}]}], 
              "\[Times]", 
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold"], "(", \(x, y, z\), ")"}]}]}]}], 
        TraditionalForm]]],
  ". "
}], "Text"],

Cell[TextData[{
  "Cuando ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " es una superficie suave y orientable a trozos se conviene en que la \
orientaci\[OAcute]n de cada parte suave y orientable de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " se haga de forma que en cada curva \[Gamma] que sea frontera \
com\[UAcute]n de dos partes suaves orientables las respectivas orientaciones \
inducidas en \[Gamma] sean opuestas. Las siguientes gr\[AAcute]ficas ",
  "te ayudar\[AAcute]n a entender estas ideas."
}], "Text"],

Cell[BoxData[
    \(\(semiesferasuperior;\)\)], "Input"],

Cell[BoxData[
    \(\(semiesferainferior;\)\)], "Input"],

Cell[BoxData[
    \(\(cilindro;\)\)], "Input"],

Cell[BoxData[
    \(\(helado;\)\)], "Input"],

Cell["\<\
El teorema de Stokes afirma que el flujo del rotacional de un campo a trav\
\[EAcute]s de una superficie suave y orientable a trozos es igual a la \
circulaci\[OAcute]n del campo en el borde de la misma.\
\>", "Text"],

Cell[TextData[{
  StyleBox["Teorema de Stokes",
    FontWeight->"Bold"],
  ". Sea ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " una superficie suave y orientable a trozos con una orientaci\[OAcute]n \
definida por el campo de vectores normales unitarios ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold"], 
          StyleBox["(",
            FontWeight->"Plain"], 
          StyleBox[\(x, y, z\),
            FontWeight->"Plain"], 
          StyleBox[")",
            FontWeight->"Plain"]}], TraditionalForm]]],
  " y representemos por ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\(S\^+\)\)]],
  " el borde de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " con la orientaci\[OAcute]n inducida. Sea ",
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontWeight->"Bold"], TraditionalForm]]],
  " un campo vectorial de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  "definido en un abierto que contenga a ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". Entonces se verifica que"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox[\(\[PartialD]\(S\^+\)\),
                FontWeight->"Bold"]], 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[".",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], 
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}]}], "=", 
          RowBox[{"\[Integral]", 
            RowBox[{
              SubscriptBox["\[Integral]", 
                StyleBox["S",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]], 
              RowBox[{"rot", " ", 
                StyleBox[\(F . n\),
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                RowBox[{"\[DifferentialD]", 
                  StyleBox["S",
                    FontSlant->"Italic"]}]}]}]}]}]], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Un caso frecuente es cuando la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " viene dada en la forma ",
  Cell[BoxData[
      \(TraditionalForm\`S = \[Gamma](A)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^\(\(2\)\(\ \)\)\
\)]],
  "y para  ",
  Cell[BoxData[
      \(TraditionalForm\`\((s, t)\) \[Element] A\)]],
  " es"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(\[Gamma](s, t)\), "=", 
        RowBox[{\((x(s, t), y(s, t), z(s, t))\), "=", 
          RowBox[{
            RowBox[{\(x(s, t)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\(y(s, t)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(z(s, t)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y la orientaci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " viene dada por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
        RowBox[{
          FormBox[
            FractionBox[
              RowBox[{
                FormBox[
                  
                  FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\) \((s, 
                        t)\)\),
                    "TraditionalForm"],
                  "TraditionalForm"], "\[Times]", 
                FormBox[
                  
                  FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\) \((s, 
                        t)\)\),
                    "TraditionalForm"],
                  "TraditionalForm"]}], 
              RowBox[{"||", 
                RowBox[{
                  FormBox[
                    
                    FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\) \((s, 
                          t)\)\),
                      "TraditionalForm"],
                    "TraditionalForm"], "\[Times]", 
                  FormBox[
                    
                    FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\) \((s, 
                          t)\)\),
                      "TraditionalForm"],
                    "TraditionalForm"]}], "||"}]],
            "TraditionalForm"], "            ", "donde", 
          FormBox[\(\[Gamma](s, t) = \((x, y, z)\) \[Element] S\),
            "TraditionalForm"], "                        "}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En el espacio de los par\[AAcute]metros consideramos la \
orientaci\[OAcute]n positiva ",
  Cell[BoxData[
      \(TraditionalForm\`s - t\)]],
  " es decir, el eje de abscisas representa la variable ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " y el de ordenadas la variable ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". En esta situaci\[OAcute]n se verifica que la orientaci\[OAcute]n \
positiva de la frontera de ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " (en el sentido que vimos al estudiar el teorema de Green) se corresponde \
con la orientaci\[OAcute]n inducida en ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  ". Esto quiere decir que si ",
  Cell[BoxData[
      \(TraditionalForm\`s = s(u), \ t = t(u)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(a \[LessEqual] u \[LessEqual] b\)\)\)]],
  " son las ecuaciones param\[EAcute]tricas de la frontera de ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " con la orientaci\[OAcute]n positiva, que notaremos ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\(A\^+\)\)]],
  ", entonces ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalGamma](u) = \[Gamma](s(u), t(u))\)]],
  " es una representaci\[OAcute]n param\[EAcute]trica de ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\(S\^+\)\)]],
  ". Podemos comprobar en este caso el teorema de Stokes. Por definici\
\[OAcute]n de integral de superficie, tenemos que:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Integral]", 
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["S",
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            RowBox[{"rot", " ", 
              StyleBox[\(F . \ n\),
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              RowBox[{"\[DifferentialD]", 
                StyleBox["S",
                  FontSlant->"Italic"]}]}]}]}], 
        StyleBox["=",
          FontSlant->"Plain"], 
        RowBox[{"\[Integral]", 
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["A",
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            RowBox[{"rot", " ", 
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{"\[Gamma]", 
                    RowBox[{"(", 
                      StyleBox[\(s, t\),
                        FontSlant->"Italic"], ")"}]}], ")"}], " ", 
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox["(",
                    FontWeight->"Bold"], 
                  RowBox[{
                    FormBox[
                      
                      FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                s\) \((s, t)\)\),
                        "TraditionalForm"],
                      "TraditionalForm"], "\[Times]", 
                    FormBox[
                      
                      FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                t\) \((s, t)\)\),
                        "TraditionalForm"],
                      "TraditionalForm"]}], ")"}]}], 
              RowBox[{"\[DifferentialD]", 
                RowBox[{"(", 
                  StyleBox[\(s, t\),
                    FontSlant->"Italic"], ")"}]}]}]}]}]}], TextForm]], "Text",\

  TextAlignment->Center],

Cell[TextData[{
  "Calculemos ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(h(s, t)\), "=", 
          RowBox[{"rot", " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{
              RowBox[{"(", 
                RowBox[{"\[Gamma]", 
                  RowBox[{"(", 
                    StyleBox[\(s, t\),
                      FontSlant->"Italic"], ")"}]}], ")"}], 
              StyleBox[".",
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox["(",
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[
                    
                    FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\) \((s, 
                          t)\)\),
                      "TraditionalForm"],
                    "TraditionalForm"], "\[Times]", 
                  FormBox[
                    
                    FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\) \((s, 
                          t)\)\),
                      "TraditionalForm"],
                    "TraditionalForm"]}], ")"}]}]}]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(F[x_, y_, z_] = {P[x, y, z], Q[x, y, z], 
          R[x, y, z]};\)\), "\[IndentingNewLine]", 
    \(\(\[Gamma][s_, t_] = {x[s, t], y[s, t], 
          z[s, t]};\)\), "\[IndentingNewLine]", 
    \(h[s_, 
        t_] = \((Curl[F[x, y, z], Cartesian[x, y, z]] /. {x \[Rule] x[s, t], 
              y \[Rule] y[s, t], z \[Rule] z[s, t]})\) . 
        Cross[D[\[Gamma][s, t], s], D[\[Gamma][s, t], t]]\)}], "Input"],

Cell["Por otra parte", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[Integral]", 
            StyleBox[\(\[PartialD]\(S\^+\)\),
              FontWeight->"Bold"]], 
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[".",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["\[DifferentialD]",
                FontWeight->"Bold",
                FontSlant->"Plain"], 
              StyleBox["r",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}]}], "=", 
        RowBox[{\(\[Integral]\+a\%b\), 
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{
              RowBox[{
                StyleBox["(",
                  FontWeight->"Plain",
                  FontSlant->"Plain"], 
                RowBox[{"\[CapitalGamma]", 
                  RowBox[{"(", 
                    StyleBox["u",
                      FontSlant->"Italic"], ")"}]}], ")"}], " ", 
              StyleBox[".",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox["\[CapitalGamma]",
                  FontWeight->"Plain"], 
                StyleBox["'",
                  FontWeight->"Bold"]}]}], 
            RowBox[{
              StyleBox["(",
                FontWeight->"Bold"], 
              StyleBox["u",
                FontSlant->"Italic"], 
              StyleBox[")",
                FontWeight->"Bold"]}], 
            RowBox[{"\[DifferentialD]", 
              StyleBox["u",
                FontSlant->"Italic"]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Calculemos ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(g(u)\), "=", 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["F",
                  FontWeight->"Bold"], "(", \(\[CapitalGamma](u)\), ")"}], 
              " ", 
              StyleBox[".",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], \(\[CapitalGamma]'\)}], \((u)\)}]}], 
        TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(\[CapitalGamma][u_] = \[Gamma][s[u], 
          t[u]];\)\), "\[IndentingNewLine]", 
    \(g[u_] = 
      F[x[s[u], t[u]], y[s[u], t[u]], z[s[u], t[u]]] . \(\[CapitalGamma]'\)[
          u]\)}], "Input"],

Cell["Reordenamos la expresi\[OAcute]n anterior.", "Text"],

Cell[BoxData[
    \(Collect[g[u], {\(s'\)[u], \(t'\)[u]}]\)], "Input"],

Cell["Definamos la funci\[OAcute]n", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(G[s_, t_]\), "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(P[x[s, t], y[s, t], z[s, t]]\), " ", 
                RowBox[{
                  SuperscriptBox["x", 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(s, t\), "]"}]}], "+", 
              RowBox[{\(Q[x[s, t], y[s, t], z[s, t]]\), " ", 
                RowBox[{
                  SuperscriptBox["y", 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(s, t\), "]"}]}], "+", 
              RowBox[{\(R[x[s, t], y[s, t], z[s, t]]\), " ", 
                RowBox[{
                  SuperscriptBox["z", 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(s, t\), "]"}]}]}], ",", 
            RowBox[{
              RowBox[{\(P[x[s, t], y[s, t], z[s, t]]\), " ", 
                RowBox[{
                  SuperscriptBox["x", 
                    TagBox[\((0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(s, t\), "]"}]}], "+", 
              RowBox[{\(Q[x[s, t], y[s, t], z[s, t]]\), " ", 
                RowBox[{
                  SuperscriptBox["y", 
                    TagBox[\((0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(s, t\), "]"}]}], "+", 
              RowBox[{\(R[x[s, t], y[s, t], z[s, t]]\), " ", 
                RowBox[{
                  SuperscriptBox["z", 
                    TagBox[\((0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(s, t\), "]"}]}]}]}], 
          "}"}]}], ";"}]], "Input"],

Cell[TextData[{
  "Observa que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["G",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Bold"], 
            StyleBox[\(s, t\),
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Bold"]}], "=", 
          RowBox[{
            StyleBox["(",
              FontWeight->"Bold"], \(\(G\_1\)(s, t), \(G\_2\)(s, t)\), 
            ")"}]}], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es un campo vectorial de dos variables."
}], "Text"],

Cell[BoxData[
    \(Simplify[
      g[u] \[Equal] G[s[u], t[u]] . {\(s'\)[u], \(t'\)[u]}]\)], "Input"],

Cell["En consecuencia tenemos que", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[Integral]", 
            StyleBox[\(\[PartialD]\(S\^+\)\),
              FontWeight->"Bold"]], 
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[".",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["\[DifferentialD]",
                FontWeight->"Bold",
                FontSlant->"Plain"], 
              StyleBox["r",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\+a\%b\), 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              RowBox[{
                RowBox[{
                  StyleBox["(",
                    FontWeight->"Plain",
                    FontSlant->"Plain"], 
                  RowBox[{"\[CapitalGamma]", 
                    RowBox[{"(", 
                      StyleBox["u",
                        FontSlant->"Italic"], ")"}]}], ")"}], 
                StyleBox[".",
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox["\[CapitalGamma]",
                    FontWeight->"Plain"], 
                  StyleBox["'",
                    FontWeight->"Bold"]}]}], 
              RowBox[{
                StyleBox["(",
                  FontWeight->"Bold"], 
                StyleBox["u",
                  FontSlant->"Italic"], 
                StyleBox[")",
                  FontWeight->"Bold"]}], 
              RowBox[{"\[DifferentialD]", 
                StyleBox["u",
                  FontSlant->"Italic"]}]}]}], 
          StyleBox["=",
            FontSlant->"Plain"], 
          RowBox[{
            RowBox[{\(\[Integral]\+a\%b\), 
              RowBox[{"g", 
                RowBox[{"(", 
                  StyleBox["u",
                    FontSlant->"Italic"], ")"}], 
                RowBox[{"\[DifferentialD]", 
                  StyleBox["u",
                    FontSlant->"Italic"]}]}]}], "=", 
            RowBox[{
              RowBox[{\(\[Integral]\+a\%b\), 
                RowBox[{"G", 
                  RowBox[{\((s \((u)\), t \((u)\))\), 
                    StyleBox[".",
                      FontWeight->"Bold"], \((s' \((u)\), t' \((u)\))\)}], 
                  RowBox[{"\[DifferentialD]", 
                    StyleBox["u",
                      FontSlant->"Italic"]}]}]}], "=", 
              RowBox[{\(\[Integral]\_\(\[PartialD]\(A\^+\)\)\), 
                RowBox[{
                  StyleBox["G",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox[".",
                    FontWeight->"Bold"], 
                  StyleBox[" ",
                    FontWeight->"Bold"], 
                  RowBox[{
                    StyleBox["\[DifferentialD]",
                      FontWeight->"Bold"], 
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"]}]}]}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Apliquemos ahora el teorema de Green para calcular ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\(\[PartialD]\(A\^+\)\)\), 
          StyleBox[\(G . \ \[DifferentialD]r\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  ". Tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox[
            StyleBox["\[Integral]",
              FontSlant->"Plain"], \(\[PartialD]\(A\^+\)\)], 
          RowBox[{
            StyleBox["G",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox["\[DifferentialD]",
                FontWeight->"Bold"], 
              StyleBox["r",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}]}], 
        StyleBox["=",
          FontWeight->"Plain",
          FontSlant->"Plain"], 
        RowBox[{
          StyleBox["\[Integral]",
            FontWeight->"Plain",
            FontSlant->"Plain"], 
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Plain",
                FontSlant->"Plain"], "A"], 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        SubscriptBox[
                          StyleBox["G",
                            FontSlant->"Italic"], "2"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["s",
                          FontSlant->"Italic"]}]], 
                    RowBox[{"(", 
                      StyleBox[\(s, t\),
                        FontSlant->"Italic"], ")"}]}], "-", 
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        SubscriptBox[
                          StyleBox["G",
                            FontSlant->"Italic"], "1"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["t",
                          FontSlant->"Italic"]}]], 
                    RowBox[{"(", 
                      StyleBox[\(s, t\),
                        FontSlant->"Italic"], ")"}]}]}], ")"}], 
              RowBox[{"\[DifferentialD]", 
                RowBox[{"(", 
                  StyleBox[\(s, t\),
                    FontSlant->"Italic"], ")"}]}]}]}]}]}], TextForm]], "Text",\

  TextAlignment->Center],

Cell[TextData[{
  "Calculemos ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[PartialD]G\_2\/\[PartialD]\ s\), 
            RowBox[{"(", 
              StyleBox[\(s, t\),
                FontSlant->"Italic"], ")"}]}], "-", 
          RowBox[{\(\[PartialD]G\_1\/\[PartialD]\ t\), 
            RowBox[{"(", 
              StyleBox[\(s, t\),
                FontSlant->"Italic"], ")"}]}]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[
    \(Simplify[
      D[\(G[s, t]\)[\([2]\)], s] - D[\(G[s, t]\)[\([1]\)], t]]\)], "Input"],

Cell[BoxData[
    \(Simplify[h[s, t] \[Equal] %]\)], "Input"],

Cell["Hemos probado as\[IAcute] que", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Integral]", 
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["S",
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            RowBox[{"rot", " ", 
              StyleBox[\(F . \ n\),
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              RowBox[{"\[DifferentialD]", 
                StyleBox["S",
                  FontSlant->"Italic"]}]}]}]}], 
        StyleBox["=",
          FontSlant->"Plain"], 
        RowBox[{
          RowBox[{"\[Integral]", 
            RowBox[{
              SubscriptBox["\[Integral]", 
                StyleBox["A",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]], 
              RowBox[{
                StyleBox["h",
                  FontSlant->"Italic"], 
                RowBox[{"(", 
                  StyleBox[\(s, t\),
                    FontSlant->"Italic"], ")"}], 
                RowBox[{"\[DifferentialD]", 
                  StyleBox[\((s, t)\),
                    FontSlant->"Italic"]}]}]}]}], 
          StyleBox["=",
            FontWeight->"Plain",
            FontSlant->"Plain"], 
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox[\(\[PartialD]\(S\^+\)\),
                FontWeight->"Bold"]], 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[".",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], 
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
lo que demuestra el teorema de Stokes en este caso particular.\
\>", "Text"],

Cell[TextData[{
  StyleBox["El teorema de Green es un caso particular del teorema de Stokes",
    FontWeight->"Bold"],
  ". Supongamos que nuestra superficie es un dominio plano ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " contenido en el plano XY y que la orientamos por la normal al plano XY en \
la direcci\[OAcute]n del eje Z positivo. Es claro que en esta \
situaci\[OAcute]n la normal unitaria es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[\((0, 0, 1)\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  " y que el borde de ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " con la orientaci\[OAcute]n inducida es precisamente el borde de ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " orientado positivamente (en el sentido que vimos al estudiar el teorema \
de Green). Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], 
          "=", \((P(x, y), Q(x, y))\)}], TraditionalForm]]],
  " un campo vectorial definido en ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  ". Aplicando el teorema de Stokes al campo vectorial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(F\_3\),
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], 
          "=", \((P(x, y), Q(x, y), 0)\)}], TraditionalForm]]],
  " obtenemos"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[Integral]", 
            StyleBox[\(\[PartialD]\(D\^+\)\),
              FontWeight->"Bold"]], 
          RowBox[{
            SubscriptBox[
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[\(\(3\)\(\ \)\),
                FontWeight->"Bold"]], 
            StyleBox[".",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["\[DifferentialD]",
                FontWeight->"Bold",
                FontSlant->"Plain"], 
              StyleBox["r",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}]}], 
        StyleBox["=",
          FontSlant->"Plain"], 
        RowBox[{"\[Integral]", 
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["D",
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            RowBox[{"rot", " ", 
              RowBox[{
                SubscriptBox[
                  StyleBox["F",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox[\(\(3\)\(\ \)\),
                    FontWeight->"Bold"]], 
                StyleBox[".",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox["k",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[DifferentialD]", 
                StyleBox["S",
                  FontSlant->"Italic"]}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es claro que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\(\[PartialD]\(D\^+\)\)\), 
            RowBox[{
              SubscriptBox[
                StyleBox["F",
                  FontWeight->"Bold"], 
                StyleBox["3",
                  FontWeight->"Bold"]], 
              StyleBox[".",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              StyleBox[\(\[DifferentialD]r\),
                FontWeight->"Bold"]}]}], 
          StyleBox["=",
            
            FontWeight->
              "Plain"], \(\[Integral]\_\(\[PartialD]\(D\^+\)\)\(P(x, 
                  y)\) \[DifferentialD]x + \(Q(x, y)\) \[DifferentialD]y\)}], 
        TraditionalForm]]],
  ". Por otra parte tenemos que"
}], "Text"],

Cell[BoxData[
    \(Curl[{P[x, y], Q[x, y], 0}, Cartesian[x, y, z]] . {0, 0, 1}\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{\(es\ decir\), ",", 
        RowBox[{
          RowBox[{"rot", " ", 
            RowBox[{
              RowBox[{
                SubscriptBox[
                  StyleBox["F",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox["3",
                    FontWeight->"Bold"]], "(", \(x, y, z\), ")"}], " ", 
              StyleBox[".",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox["k",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}], 
          StyleBox["=",
            FontWeight->"Plain",
            FontSlant->"Plain"], 
          RowBox[{
            StyleBox[
              RowBox[{
                FractionBox[
                  StyleBox[\(\[PartialD]Q\),
                    FontWeight->"Plain",
                    FontSlant->"Plain"], \(\[PartialD]\ x\)], \((x, y)\)}],
              FontWeight->"Plain",
              FontSlant->"Plain"], 
            StyleBox["-",
              FontWeight->"Plain",
              FontSlant->"Plain"], 
            RowBox[{
              FractionBox[
                StyleBox[\(\[PartialD]P\),
                  FontWeight->"Plain",
                  FontSlant->"Plain"], \(\[PartialD]\ y\)], 
              RowBox[{\((x, y)\), ".", " ", 
                StyleBox["Concluimos",
                  FontSlant->"Plain"]}], 
              StyleBox[" ",
                FontSlant->"Plain"], 
              StyleBox["que",
                FontSlant->"Plain"]}]}]}]}], TraditionalForm]], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(\[Integral]\_\(\[PartialD]\(D\^+\)\)\), 
            RowBox[{
              StyleBox["P",
                FontSlant->"Italic"], 
              StyleBox[\((x, y)\),
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontSlant->"Plain"], 
                StyleBox["x",
                  FontSlant->"Italic"]}]}]}], 
          StyleBox["+",
            FontSlant->"Italic"], 
          RowBox[{
            StyleBox["Q",
              FontSlant->"Italic"], 
            StyleBox[\((x, y)\),
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["\[DifferentialD]",
                FontSlant->"Plain"], 
              StyleBox["y",
                FontSlant->"Italic"]}]}]}], 
        StyleBox["=",
          FontSlant->"Plain"], 
        RowBox[{"\[Integral]", 
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["D",
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  StyleBox[
                    RowBox[{
                      FractionBox[
                        RowBox[{
                          StyleBox["\[PartialD]",
                            FontWeight->"Plain",
                            FontSlant->"Plain"], 
                          StyleBox["Q",
                            FontWeight->"Plain",
                            FontSlant->"Italic"]}], 
                        RowBox[{
                          StyleBox["\[PartialD]",
                            FontSlant->"Plain"], " ", "x"}]], \((x, y)\)}],
                    FontWeight->"Plain",
                    FontSlant->"Italic"], 
                  StyleBox["-",
                    FontWeight->"Plain",
                    FontSlant->"Italic"], 
                  StyleBox[
                    RowBox[{
                      FractionBox[
                        RowBox[{
                          StyleBox["\[PartialD]",
                            FontWeight->"Plain",
                            FontSlant->"Plain"], 
                          StyleBox["P",
                            FontWeight->"Plain",
                            FontSlant->"Italic"]}], 
                        RowBox[{
                          StyleBox["\[PartialD]",
                            FontSlant->"Plain"], " ", "y"}]], \((x, y)\)}],
                    FontSlant->"Italic"]}], ")"}], 
              RowBox[{"\[DifferentialD]", 
                StyleBox["S",
                  FontSlant->"Italic"]}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["Teorema de la divergencia", "Section"],

Cell[TextData[{
  "Ya conocemos una versi\[OAcute]n del teorema de la divergencia para campos \
vectoriales de dos variables. En la generalizaci\[OAcute]n de dicho teorema \
para campos vectoriales de tres variables se consideran ",
  StyleBox["dominios regulares ",
    FontSlant->"Italic"],
  "en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". Recuerda que un dominio es un conjunto abierto y conexo. La frontera de \
un dominio acotado es una superficie ",
  StyleBox["cerrada",
    FontSlant->"Italic"],
  ". Sea ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " un dominio acotado en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ", d",
  "iremos que ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  "  es un ",
  StyleBox["dominio regular",
    FontWeight->"Bold"],
  " cuando su frontera, que representaremos por ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]D\)]],
  ", ",
  "est\[EAcute] formada por trozos de superficies que tienen plano tangente \
en todo punto. No excluimos la posibilidad de que en \"las uniones\" de \
dichas superficies haya ",
  StyleBox["aristas",
    FontSlant->"Italic"],
  " en cuyos puntos no est\[EAcute] definido un plano tangente. El interior \
de una esfera o de un ortoedro son ejemplos de dominios regulares el segundo \
de ellos con aristas. \nLas ",
  StyleBox["superficies cerradas",
    FontSlant->"Italic"],
  " que son frontera de un dominio regular se orientan mediante la ",
  StyleBox["normal exterior",
    FontSlant->"Italic"],
  ", concepto \[EAcute]ste que, aunque tiene un significado intuitivo para \
las superficies cerradas m\[AAcute]s usuales, es f\[AAcute]cil de precisar \
matem\[AAcute]ticamente. En cada punto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]D\)]],
  " (excepto quiz\[AAcute]s en las aristas si las hay, pero estos conjuntos \
de puntos son tan peque\[NTilde]os que no influyen para nada en la integral) \
est\[AAcute]n definidas dos normales unitarias que son opuestas una de otra. \
Sea ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \[PartialD]D\)]],
  " y sea ",
  StyleBox["N",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " un vector normal a ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  "en ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Se dice que ",
  StyleBox["N",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "es ",
  StyleBox["normal exterior",
    FontWeight->"Bold"],
  " a ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " si para ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta] > 0\)]],
  " suficientemente peque\[NTilde]o y para ",
  Cell[BoxData[
      \(TraditionalForm\`0 < t < \[Delta]\)]],
  " se verifica que:  "
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"x", "-", 
            RowBox[{"t", " ", 
              StyleBox["N",
                FontWeight->"Bold"]}]}], "\[Element]", "D"}], ",", "  ", 
        RowBox[{
          RowBox[{"x", " ", "+", " ", 
            RowBox[{"t", " ", 
              StyleBox["N",
                FontWeight->"Bold"]}]}], " ", "\[NotElement]", " ", "D"}]}], 
      TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "condiciones que expresan que si a partir del punto ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " nos deplazamos un poquito en la direcci\[OAcute]n de ",
  StyleBox["N",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["salimos",
    FontSlant->"Italic"],
  " de ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " y si nos deplazamos en la direcci\[OAcute]n opuesta a ",
  StyleBox["N",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " ",
  StyleBox["entramos",
    FontSlant->"Italic"],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  ".",
  " Se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]D\)]],
  " es una superficie orientable y suave a trozos y la aplicaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", "\[Rule]", " ", 
          RowBox[{
            StyleBox["n",
              FontWeight->"Bold"], "(", "x", ")"}]}], TraditionalForm]]],
  " que a cada punto ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \[PartialD]D\)]],
  "(con la salvedad indicada)",
  " hace corresponder la normal exterior a ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]D\)]],
  " en dicho punto define una orientaci\[OAcute]n que se llamar\[AAcute] la \
",
  StyleBox["orientaci\[OAcute]n positiva",
    FontWeight->"Bold"],
  " de ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]D\)]],
  ". "
}], "Text"],

Cell[TextData[{
  StyleBox["Teorema de la divergencia",
    FontWeight->"Bold"],
  ". Sea ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " un dominio regular en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ", ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " un campo vectorial de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  " definido en un abierto que contiene a ",
  Cell[BoxData[
      \(TraditionalForm\`D \[Union] \[PartialD]D\)]],
  " y consideremos la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]D\)]],
  " orientada positivamente. Entonces se verifica que"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        FormBox[
          RowBox[{
            RowBox[{"\[Integral]", 
              RowBox[{\(\[Integral]\_\(\[PartialD]D\)\), 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    StyleBox["n",
                      FontWeight->"Bold"]}], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  StyleBox[\(\[DifferentialD]S\),
                    FontWeight->"Plain"]}]}]}], 
            StyleBox[" ",
              FontWeight->"Plain"], 
            StyleBox["=",
              FontWeight->"Plain"], 
            StyleBox[" ",
              FontWeight->"Plain"], 
            RowBox[{
              StyleBox["\[Integral]",
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox["\[Integral]",
                  FontWeight->"Plain"], 
                RowBox[{
                  SubscriptBox[
                    StyleBox["\[Integral]",
                      FontWeight->"Plain"], "D"], 
                  RowBox[{"div", " ", 
                    RowBox[{
                      StyleBox["F",
                        FontWeight->"Bold"], "(", \(x, y, z\), 
                      ")"}], \(\[DifferentialD]\((x, y, z)\)\)}]}]}]}]}],
          "TraditionalForm"]], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es decir, el flujo del campo ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " a trav\[EAcute]s de la frontera ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]D\)]],
  "del dominio ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " es igual a la integral de la divergencia del campo en ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  ". Este teorema relaciona una integral de superficie con una integral de \
volumen. El teorema de la divergencia tiene dos autores Gauss y Ostrogradsky \
los textos atribuyen su autor\[IAcute]a a uno u otro seg\[UAcute]n las simpat\
\[IAcute]as del autor de turno aunque lo m\[AAcute]s justo, como hacen muchos \
textos, ser\[IAcute]a llamarle teorema de Gauss-Ostrogradsky. "
}], "Text"],

Cell[TextData[{
  "Aplicando el teorema de la divergencia al dominio ",
  Cell[BoxData[
      \(TraditionalForm\`B(x, \[Epsilon])\)]],
  " formado por una bola de centro ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " y radio \[Epsilon] se deduce f\[AAcute]cilmente que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(lim\_\(\[Epsilon] \[Rule] 0\)\), 
          RowBox[{\(1\/\(vol(B(x, \[Epsilon]))\)\), 
            RowBox[{"\[Integral]", 
              RowBox[{\(\[Integral]\_\(\[PartialD]\(B(x, \[Epsilon])\)\)\), 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    StyleBox["n",
                      FontWeight->"Bold"]}], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  StyleBox[\(\[DifferentialD]S\),
                    FontWeight->"Plain"]}]}]}]}]}], 
        StyleBox["=",
          FontWeight->"Plain"], 
        RowBox[{
          StyleBox["div",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", 
            StyleBox[\(x, y, z\),
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "lo que permite interpretar la divergencia como el l\[IAcute]mite del flujo \
por unidad de volumen. Claramente, cuando",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{"div", " ", 
              RowBox[{
                StyleBox["F",
                  FontWeight->"Bold"], "(", \(x, y, z\), ")"}]}], ">", 
            "0"}]}], TraditionalForm]]],
  " entonces para todo",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[Epsilon] > 0\)\)\)]],
  " suficientemente peque\[NTilde]o se tiene que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{\(\[Integral]\_\(\[PartialD]\(B(x, \[Epsilon])\)\)\), 
              RowBox[{
                RowBox[{
                  StyleBox["F",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox[".",
                    FontWeight->"Bold"], 
                  StyleBox[" ",
                    FontWeight->"Bold"], 
                  StyleBox["n",
                    FontWeight->"Bold"]}], 
                StyleBox[" ",
                  FontWeight->"Plain"], 
                StyleBox[\(\[DifferentialD]S\),
                  FontWeight->"Plain"]}]}],
            "TraditionalForm"], ">", "0"}], TraditionalForm]]],
  " de modo que el flujo neto a trav\[EAcute]s de ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\(B(x, \[Epsilon])\)\)]],
  " es en sentido hacia afuera. An\[AAcute]logamente, cuando ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{"div", " ", 
              RowBox[{
                StyleBox["F",
                  FontWeight->"Bold"], "(", \(x, y, z\), ")"}]}], "<", 
            "0"}]}], TraditionalForm]]],
  " el flujo neto a trav\[EAcute]s de ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\(B(x, \[Epsilon])\)\)]],
  " es en sentido hacia dentro."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Aplicaciones de los teorema de Stokes y de la \
divergencia",
  FontWeight->"Bold"]], "Section"],

Cell[TextData[{
  "Este apartado est\[AAcute] copiado casi literalmente de los apuntes de An\
\[AAcute]lisis del profesor de la Universidad de Valencia Dr. Carlos Ivorra. \
Puedes descargar dichos apuntes y otros muchos, todos ellos excelentes, de su \
p\[AAcute]gina Web http://www.uv.es/~ivorra. \n",
  StyleBox["El rotacional en hidrodin\[AAcute]mica",
    FontWeight->"Bold"],
  "\nEmpezaremos viendo una interpretaci\[OAcute]n de la circulaci\[OAcute]n \
de un campo en el contexto de la hidrodin\[AAcute]mica. Supongamos que ",
  Cell[BoxData[
      FormBox[
        StyleBox["V",
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "es el campo de velocidades de un fluido. Esto significa que si liberamos \
una part\[IAcute]cula de masa despreciable en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " el fluido la arrastrar\[AAcute] con velocidad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["V",
            FontWeight->"Bold"], "(", "p", ")"}], TraditionalForm]]],
  " (no excluimos que ",
  Cell[BoxData[
      FormBox[
        StyleBox["V",
          FontWeight->"Bold"], TraditionalForm]]],
  " pueda depender del tiempo adem\[AAcute]s de hacerlo de la \
posici\[OAcute]n). Supongamos ahora que en el fluido situamos una bolita \
sujeta por una varilla r\[IAcute]gida a un eje, respecto al cual puede girar \
a lo largo de una circunferencia de radio ",
  StyleBox["r",
    FontSlant->"Italic"],
  ". Es claro que si la bolita se encuentra en el punto ",
  StyleBox["p ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  "el fluido la har\[AAcute] moverse con velocidad igual a la proyecci\
\[OAcute]n de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["V",
            FontWeight->"Bold"], " ", \((p)\), " "}], TraditionalForm]]],
  "sobre la recta tangente a la circunferencia en ",
  StyleBox["p",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  ", pues la componente normal de la velocidad ser\[AAcute] cancelada por las \
fuerzas que mantienen r\[IAcute]gida a la varilla que sujeta la bola. ",
  StyleBox["Imaginemos ahora que el eje sujeta a la varilla por el centro y \
que \[EAcute]sta tiene una bolita en cada brazo como se muestra en la \
siguiente figura.",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[BoxData[
    \(\(molinillo;\)\)], "Input"],

Cell[TextData[{
  StyleBox["Si las bolitas se encuentran en los puntos ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`p\_1\)]],
  StyleBox[" y ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`p\_2\)]],
  StyleBox[", entonces su velocidad (que en m\[OAcute]dulo ha de ser la misma \
para ambas a causa de la rigidez de la varilla) estar\[AAcute] determinada \
por los vectores ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["V",
            FontWeight->"Bold"], " ", \((p\_1)\)}], TraditionalForm]]],
  StyleBox[" y  ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["V",
            FontWeight->"Bold"], " ", \((p\_2)\)}], TraditionalForm]]],
  StyleBox[". Al igual que en el caso anterior en realidad depender\[AAcute] \
s\[OAcute]lo de las proyecciones ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["v",
                    FontWeight->"Bold"], "1"], "=", 
                RowBox[{
                  StyleBox["V",
                    FontWeight->"Bold"], " ", \((p\_1)\), " "}]}],
              "TraditionalForm"], 
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], "(", \(p\_1\), ")"}]}], 
          RowBox[{
            StyleBox["T",
              FontWeight->"Bold"], "(", \(p\_1\), ")"}]}], 
        TraditionalForm]]],
  StyleBox["  y  ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["v",
                    FontWeight->"Bold"], "2"], "=", 
                RowBox[{
                  StyleBox["V",
                    FontWeight->"Bold"], " ", \((p\_2)\), " "}]}],
              "TraditionalForm"], 
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], "(", \(p\_2\), ")"}]}], " ", 
          RowBox[{
            StyleBox["T",
              FontWeight->"Bold"], "(", \(p\_2\), ")"}]}], 
        TraditionalForm]]],
  " (donde hemos notado por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["T",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["p",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], Cell[""]}], TraditionalForm]]],
  "el vector tangente unitario a la circunferencia en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ").",
  StyleBox[" Por ejemplo, en el caso indicado en la figura, donde  ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                StyleBox["V",
                  FontWeight->"Bold"], " ", \((p\_1)\), " "}],
              "TraditionalForm"], 
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], "(", \(p\_1\), ")"}]}], "=", "2"}], 
        TraditionalForm]]],
  StyleBox[" y ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                StyleBox["V",
                  FontWeight->"Bold"], " ", \((p\_2)\), " "}],
              "TraditionalForm"], 
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], "(", \(p\_2\), ")"}]}], "=", "1"}], 
        TraditionalForm]]],
  StyleBox[", la velocidad resultante ser\[AAcute] el promedio de ambas: la \
varilla girar\[AAcute] en sentido contrario a las agujas del reloj con \
velocidad ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`\((2\  - \ 1)\)/2\  = \ 1/2\)]],
  StyleBox[". La justificaci\[OAcute]n de esto es la siguiente. Se trata de \
un problema de conservaci\[OAcute]n de la cantidad de movimiento. De hecho es \
equivalente al siguiente: dos cuerpos de la misma masa se aproximan \
frontalmente de modo que sus velocidades son ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`v\_1\)]],
  StyleBox[" y ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`v\_2\)]],
  StyleBox[". Si tras el choque se mueven conjuntamente, \[DownQuestion]a qu\
\[EAcute] velocidad lo hacen? La respuesta es que la cantidad de movimiento \
del sistema es ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`m\ \(\(v\)\(\ \)\)\_1 + \ m\ v\_2\)]],
  StyleBox[" al principio y ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`2  m\ v\)]],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["al final. Igualando resulta que ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`v\  = \ \((v\_1\  + \ v\_2)\)/2\)]],
  StyleBox[". El fluido comunica una cantidad de movimiento a las bolitas y \
la varilla se limita a unificar las velocidades sin alterar la cantidad de \
movimiento.\nSupongamos ahora que en vez de una varilla con dos bolitas \
tenemos un molinillo con ",
    FontFamily->"Times New Roman"],
  StyleBox["n ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["aspas. Entonces el valor num\[EAcute]rico de la velocidad \
resultante ser\[AAcute]",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(1\/n\), 
              RowBox[{
                RowBox[{
                  StyleBox["V",
                    FontWeight->"Bold"], "(", \(p\_1\), ")"}], " ", 
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox["T",
                    FontWeight->"Bold"], "(", \(p\_1\), ")"}]}]}], "+", 
            RowBox[{\(1\/n\), 
              RowBox[{
                RowBox[{
                  StyleBox["V",
                    FontWeight->"Bold"], "(", \(p\_2\), ")"}], " ", 
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox["T",
                    FontWeight->"Bold"], "(", \(p\_2\), ")"}]}]}], "+"}], 
          "..."}], "+", 
        RowBox[{\(1\/n\), 
          RowBox[{
            RowBox[{
              StyleBox["V",
                FontWeight->"Bold"], "(", \(p\_n\), ")"}], " ", 
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], "(", \(p\_n\), ")"}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["Que podemos escribir en la forma", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(1\/\(2  \[Pi]\ r\)\), 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{\(\(2  \[Pi]\ r\)\/n\), 
                  RowBox[{
                    RowBox[{
                      StyleBox["V",
                        FontWeight->"Bold"], "(", \(p\_1\), ")"}], " ", 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["T",
                        FontWeight->"Bold"], "(", \(p\_1\), ")"}]}]}], "+", 
                RowBox[{\(\(2  \[Pi]\ r\)\/n\), 
                  RowBox[{
                    RowBox[{
                      StyleBox["V",
                        FontWeight->"Bold"], "(", \(p\_2\), ")"}], " ", 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["T",
                        FontWeight->"Bold"], "(", \(p\_2\), ")"}]}]}], "+"}], 
              "..."}], "+", 
            RowBox[{\(\(2  \[Pi]\ r\)\/n\), 
              RowBox[{
                RowBox[{
                  StyleBox["V",
                    FontWeight->"Bold"], "(", \(p\_n\), ")"}], " ", 
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox["T",
                    FontWeight->"Bold"], "(", \(p\_n\), ")"}]}]}]}], ")"}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  StyleBox["r",
    FontSlant->"Italic"],
  " es el radio de la circunferencia. ",
  "Esto equivale a considerar la circunferencia dividida en ",
  StyleBox["n ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  "partes iguales de longitud ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\ s = 2  \[Pi]\ r/n\)]],
  ", multiplicar la longitud de cada parte por el valor de ",
  StyleBox["V.T",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  "en uno de sus puntos, sumar y luego dividir el resultado entre la longitud \
completa de la circunferencia. Finalmente, si en lugar de un molinillo \
ponemos un disco ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " de radio ",
  StyleBox["r",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  ", el valor num\[EAcute]rico de la velocidad que le imprimir\[AAcute] el \
fluido vendr\[AAcute] dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{"v", "=", 
            RowBox[{\(1\/\(2  \[Pi]\ r\)\), 
              RowBox[{\(\[Integral]\_C\), 
                RowBox[{
                  StyleBox[\(V . T\),
                    FontWeight->"Bold"], \(\[DifferentialD]s\)}]}]}]}],
          "TraditionalForm"], "=", 
        RowBox[{\(1\/\(2  \[Pi]\ r\)\), 
          RowBox[{\(\[Integral]\_C\), 
            RowBox[{
              StyleBox["V",
                FontWeight->"Bold"], 
              StyleBox[".",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              RowBox[{"\[DifferentialD]", 
                StyleBox["r",
                  FontWeight->"Bold"]}]}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La velocidad ",
  StyleBox["v ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  "corresponde a una velocidad angular ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_\(\(\ \)\(r\)\) = \ v/r\)]],
  ". As\[IAcute] pues, representando por ",
  StyleBox["C  ",
    FontSlant->"Italic"],
  "la circunferencia del disco ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " orientada positivamente, tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\(\(\[Omega]\_\(\(\ \)\(r\)\)\)\(=\)\),
          "TraditionalForm"], \(1\/\(2  \[Pi]\ r\^2\)\), 
        RowBox[{\(\[Integral]\_C\), 
          RowBox[{
            StyleBox["V",
              FontWeight->"Bold"], 
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            RowBox[{"\[DifferentialD]", 
              StyleBox["r",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Sea ahora ",
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " un vector unitario normal al disco. En virtud del teorema de Stokes se \
verifica que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_C\), 
          RowBox[{
            StyleBox["V",
              FontWeight->"Bold"], 
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            RowBox[{"\[DifferentialD]", 
              StyleBox["r",
                FontWeight->"Bold"]}]}]}], 
        StyleBox["=",
          FontWeight->"Plain"], 
        RowBox[{"\[Integral]", 
          RowBox[{\(\[Integral]\_S\), 
            RowBox[{
              RowBox[{
                StyleBox[
                  RowBox[{"rot", 
                    StyleBox["V",
                      FontWeight->"Bold"]}]], 
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                StyleBox["n",
                  FontWeight->"Bold"]}], \(\[DifferentialD]S\)}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Si el centro del disco es el punto ",
  StyleBox["p",
    FontSlant->"Italic"],
  " y el radio ",
  StyleBox["r",
    FontSlant->"Italic"],
  " es suficientemente peque\[NTilde]o se verifica que "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Integral]", 
          RowBox[{\(\[Integral]\_S\), 
            RowBox[{
              RowBox[{
                StyleBox[
                  RowBox[{"rot", 
                    StyleBox["V",
                      FontWeight->"Bold"]}]], 
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                StyleBox["n",
                  FontWeight->"Bold"]}], \(\[DifferentialD]S\)}]}]}], 
        "\[TildeEqual]", 
        RowBox[{"\[Pi]", " ", \(r\^2\), "rot", " ", 
          RowBox[{
            RowBox[{
              StyleBox["V",
                FontWeight->"Bold"], "(", "p", ")"}], " ", 
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            StyleBox["n",
              FontWeight->"Bold"], " "}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["y por tanto", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[\(\(\[Omega]\_\(\(\ \)\(r\)\)\)\(=\)\),
            "TraditionalForm"], \(1\/\(2  \[Pi]\ r\^2\)\), 
          RowBox[{\(\[Integral]\_C\), 
            RowBox[{
              StyleBox["V",
                FontWeight->"Bold"], 
              StyleBox[".",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              RowBox[{"\[DifferentialD]", 
                StyleBox["r",
                  FontWeight->"Bold"]}]}]}]}], "=", 
        RowBox[{
          RowBox[{\(1\/\(2  \[Pi]\ r\^2\)\), 
            RowBox[{"\[Integral]", 
              RowBox[{\(\[Integral]\_S\), 
                RowBox[{
                  RowBox[{
                    StyleBox[
                      RowBox[{"rot", 
                        StyleBox["V",
                          FontWeight->"Bold"]}]], 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    StyleBox["n",
                      FontWeight->"Bold"]}], \(\[DifferentialD]S\)}]}]}]}], 
          "\[TildeEqual]", 
          RowBox[{\(1\/2\), "rot", " ", 
            RowBox[{
              RowBox[{
                StyleBox["V",
                  FontWeight->"Bold"], "(", "p", ")"}], " ", 
              StyleBox[".",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              StyleBox["n",
                FontWeight->"Bold"], " "}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["En el l\[IAcute]mite se tiene la igualdad", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(lim\_\(\(\ \)\(r \[Rule] \ 0\)\)\ \[Omega]\_\(\(\ \)\(r\)\)\),
         "=", 
        RowBox[{\(1\/2\), "rot", " ", 
          RowBox[{
            RowBox[{
              StyleBox["V",
                FontWeight->"Bold"], "(", "p", ")"}], " ", 
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            StyleBox["n",
              FontWeight->"Bold"], " "}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
As\[IAcute] pues, la velocidad angular que adquirir\[AAcute] la rueda es \
(aproximadamente) la mitad de la proyecci\[OAcute]n del rotacional sobre el \
eje de giro. Claramente el rotacional indica la direcci\[OAcute]n en que \
hemos de situar el eje para que la velocidad de rotaci\[OAcute]n sea m\
\[AAcute]xima.\
\>", "Text"],

Cell[TextData[{
  StyleBox["La ecuaci\[OAcute]n de continuidad",
    FontWeight->"Bold"],
  "\nSea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["V",
            FontWeight->"Bold"], "(", \(x, y, z, t\), ")"}], 
        TraditionalForm]]],
  " el campo de velocidades de un fluido y sea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho](x, y, z, t)\)]],
  "su densidad (en general ambos dependen de la posici\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " y del tiempo ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  "). Sea ",
  Cell[BoxData[
      \(TraditionalForm\`p = \((x, y, z)\)\)]],
  " un punto cualquiera y ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  "una esfera de centro ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ". La cantidad de fluido contenida en ",
  StyleBox["S ",
    FontSlant->"Italic"],
  "en un instante dado es la integral de \[Rho]",
  StyleBox[" ",
    FontSlant->"Italic"],
  "sobre la bola ",
  StyleBox["B ",
    FontSlant->"Italic"],
  "de frontera ",
  StyleBox["S",
    FontSlant->"Italic"],
  ", luego la variaci\[OAcute]n de esta masa (debida a la variaci\[OAcute]n \
de la densidad del fluido respecto al tiempo) es"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\(\(d\/\(d\ t\)\) \
\(\[Integral]\(\[Integral]\(\[Integral]\_B\( \[Rho](x, y, z, 
                      t)\) \[DifferentialD]\((x, y, z)\)\)\)\)\),
          "TraditionalForm"], 
        "=", \(\[Integral]\(\[Integral]\(\[Integral]\_B\(\[PartialD]\/\
\[PartialD]t\) \(\[Rho](x, y, z, t)\) \[DifferentialD]\((x, y, z)\)\)\)\)}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En la lecci\[OAcute]n anterior vimos que el flujo del campo ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{"\[Rho]", 
            StyleBox["V",
              FontWeight->"Bold"]}]], TraditionalForm]]],
  " a trav\[EAcute]s de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " se interpreta como la masa de fluido que sale de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " por unidad de tiempo. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " el radio de ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " y"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\(\[Psi]\_r\)(p, t)\), "=", 
        RowBox[{
          
          RowBox[{\(\[Integral]\(\[Integral]\(\[Integral]\_B\(\[PartialD]\/\
\[PartialD]t\) \(\[Rho](x, y, z, t)\) \[DifferentialD]\((x, y, z)\)\)\)\), 
            "+", 
            RowBox[{"\[Integral]", 
              RowBox[{\(\[Integral]\_S\), 
                RowBox[{\(\[Rho](x, y, z, t)\), 
                  RowBox[{
                    RowBox[{
                      StyleBox["V",
                        FontWeight->"Bold"], "(", \(x, y, z, t\), ")"}], " ", 
                    
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["n",
                        FontWeight->"Bold"], "(", \(x, y, z\), 
                      ")"}]}], \(\[DifferentialD]S\)}]}]}]}], "=", 
          "\[IndentingNewLine]", 
          RowBox[{
            
            RowBox[{\(\[Integral]\(\[Integral]\(\[Integral]\_B\(\[PartialD]\/\
\[PartialD]t\) \(\[Rho](x, y, z, t)\) \[DifferentialD]\((x, y, z)\)\)\)\), 
              "+", 
              RowBox[{"\[Integral]", 
                RowBox[{"\[Integral]", 
                  RowBox[{\(\[Integral]\_B\), 
                    RowBox[{
                      RowBox[{"div", "(", 
                        RowBox[{\(\[Rho](x, y, z, t)\), 
                          RowBox[{
                            StyleBox["V",
                              FontWeight->"Bold"], "(", \(x, y, z, t\), 
                            ")"}]}], 
                        ")"}], \(\[DifferentialD]\((x, y, z)\)\)}]}]}]}]}], 
            "=", "\[IndentingNewLine]", 
            RowBox[{"\[Integral]", 
              RowBox[{"\[Integral]", 
                RowBox[{\(\[Integral]\_B\), 
                  RowBox[{
                    RowBox[{"(", 
                      
                      RowBox[{\(\(\[PartialD]\/\[PartialD]t\) \(\[Rho](x, y, 
                            z, t)\)\), "+", 
                        RowBox[{"div", "(", 
                          RowBox[{\(\[Rho](x, y, z, t)\), 
                            RowBox[{
                              StyleBox["V",
                                FontWeight->"Bold"], "(", \(x, y, z, t\), 
                              ")"}]}], ")"}]}], 
                      ")"}], \(\[DifferentialD]\((x, y, z)\)\)}]}]}]}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde en la segunda igualdad hemos usado el teorema de la divergencia (se \
entiende que el operador divergencia \"div\" indica derivaci\[OAcute]n \
respecto a las variables espaciales ",
  Cell[BoxData[
      \(TraditionalForm\`x, y, z\)]],
  "). As\[IAcute], ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Psi]\_r\)(p, t)\)]],
  "es el incremento de la masa de fluido en ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " por unidad de tiempo ",
  StyleBox["menos",
    FontSlant->"Italic"],
  " la cantidad de masa que ",
  StyleBox["entra",
    FontSlant->"Italic"],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " a trav\[EAcute]s de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " por unidad de tiempo. Por consiguiente ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Psi]\_r\)(p, t)\)/\(vol(B)\)\)]],
  " es la cantidad de masa neta que se crea en ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(B\)\(\ \)\)\)]],
  "por unidad de tiempo y de volumen (el aumento o la disminuci\[OAcute]n de \
masa en ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " que no entra ni sale por su frontera). Un razonamiento ya varias veces \
repetido permite probar f\[AAcute]cilmente que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Psi](p, t)\), "=", 
        FormBox[
          
          RowBox[{\(lim\_\(r \[Rule] 0\)\(\(\[Psi]\_r\)(p, t)\)\/\(vol(B)\)\),
             "=", 
            FormBox[
              
              RowBox[{\(\(\[PartialD]\/\[PartialD]t\) \(\[Rho](x, y, z, 
                    t)\)\), "+", 
                RowBox[{"div", "(", 
                  RowBox[{\(\[Rho](x, y, z, t)\), 
                    RowBox[{
                      StyleBox["V",
                        FontWeight->"Bold"], "(", \(x, y, z, t\), ")"}]}], 
                  ")"}]}],
              "TraditionalForm"]}],
          "TraditionalForm"]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi](p)\)]],
  " representa la cantidad de fluido que se crea alrededor de ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " por unidad de tiempo y de volumen. La ecuaci\[OAcute]n"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Psi](p, t)\), "=", 
        RowBox[{\(div(\(\[Rho](p, t)\)\ \(V(p, t)\))\), 
          
          FormBox[\(\(+\ \(\[PartialD]\[Rho]\/\[PartialD]\ t\)\) \((p, t)\)\),
            
            "TraditionalForm"]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "se denomina",
  StyleBox[" ecuaci\[OAcute]n de continuidad de la hidrodin\[AAcute]mica",
    FontWeight->"Bold"],
  ". \nLos puntos donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi] > 0\)]],
  "se llaman ",
  StyleBox["fuentes",
    FontWeight->"Bold"],
  " (son puntos donde aparece fluido) y los puntos donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi] < 0\)]],
  " se llaman ",
  StyleBox["sumideros",
    FontWeight->"Bold"],
  " (en los cuales desaparece fluido). Si no hay fuentes ni sumideros, es \
decir, cuando la masa neta se conserva, se tiene que \[Psi] es \
id\[EAcute]nticamente nula y la ecuaci\[OAcute]n de continuidad adopta la \
forma m\[AAcute]s usual"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(div(\(\[Rho](p, t)\)\ \(V(p, t)\))\), 
          
          FormBox[\(\(+\ \(\[PartialD]\[Rho]\/\[PartialD]\ t\)\) \((p, t)\)\),
            
            "TraditionalForm"]}], "=", "0"}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Si la densidad \[Rho] es constante el fluido se llama ",
  StyleBox["incompresible ",
    FontWeight->"Bold"],
  " y entonces la ecuaci\[OAcute]n fundamental se reduce a que ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Rho]", " ", "div", " ", 
          StyleBox["V",
            FontWeight->"Bold"]}], TraditionalForm]]],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " es igual a la cantidad de fluido que se crea alrededor de ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " por unidad de masa y de volumen. Si adem\[AAcute]s no hay fuentes ni \
sumideros, la ecuaci\[OAcute]n de continuidad se reduce a ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"div", " ", 
            StyleBox["V",
              FontWeight->"Bold"]}], "=", "0"}], TraditionalForm]]],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["La ley de Gauss y la ecuaci\[OAcute]n de Poisson en electrost\
\[AAcute]tica",
    FontWeight->"Bold"],
  "\n",
  "Recuerda que el campo el\[EAcute]ctrico creado por una carga puntual ",
  StyleBox["Q ",
    FontSlant->"Italic"],
  "situada en un punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["a",
            FontWeight->"Bold"], 
          "\[Element]", \(\[DoubleStruckCapitalR]\^3\)}], TraditionalForm]]],
  "viene dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(E \((x)\)\),
          FontWeight->"Bold",
          FontSlant->"Italic"], "=", 
        RowBox[{\(1\/\(4  \[Pi]\ \[Epsilon]\)\), 
          StyleBox[
            FractionBox[
              StyleBox[\(\(\ \ \)\(Q\)\),
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["||",
                  FontSlant->"Plain"], 
                RowBox[{
                  StyleBox["x",
                    FontWeight->"Bold"], 
                  StyleBox["-",
                    FontWeight->"Plain"], 
                  StyleBox["a",
                    FontWeight->"Bold"]}], 
                SuperscriptBox[
                  StyleBox["||",
                    FontSlant->"Plain"], 
                  StyleBox["3",
                    FontSlant->"Plain"]]}]],
            FontSlant->"Italic"], 
          RowBox[{
            StyleBox["(",
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["x",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox["-",
                FontWeight->"Plain",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox["a",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], 
            StyleBox[")",
              FontWeight->"Plain",
              FontSlant->"Italic"]}], "                  ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                StyleBox["x",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                "\[Element]", \(\[DoubleStruckCapitalR]\^3\)}], ",", 
              RowBox[{
                StyleBox["x",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], "\[NotEqual]", 
                StyleBox["a",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}], ")"}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde \[Epsilon] es la ",
  StyleBox["permisividad",
    FontWeight->"Bold"],
  " del medio. Recuerda que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["E",
              FontWeight->"Bold"], "(", 
            StyleBox["x",
              FontWeight->"Bold"], ")"}], " "}], TraditionalForm]]],
  "es la fuerza que experimentar\[IAcute]a una carga positiva de 1 culombio \
que estuviera situada en el punto ",
  StyleBox["x",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". Es f\[AAcute]cil comprobar por c\[AAcute]lculo directo que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"div", " ", 
            RowBox[{
              StyleBox["E",
                FontWeight->"Bold"], "(", 
              StyleBox["x",
                FontWeight->"Bold"], ")"}]}], "=", "0"}], TraditionalForm]]],
  " para todo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          "\[Element]", \(\[DoubleStruckCapitalR]\^3\)}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], "\[NotEqual]", 
          StyleBox["a",
            FontWeight->"Bold"]}], TraditionalForm]]],
  ". En consecuencia, el teorema de la divergencia nos dice que el flujo el\
\[EAcute]ctrico neto a trav\[EAcute]s de cualquier superficie cerrada que no \
rodee al punto ",
  StyleBox["a",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es nulo. Observa que si la superficie cerrada contiene al punto ",
  StyleBox["a",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " entonces no podemos aplicar el teorema de la divergencia porque el campo \
no est\[AAcute] definido en ning\[UAcute]n abierto que contenga a dicha \
superficie y a su interior. Estudiemos lo que ocurre en este caso. Sea ",
  StyleBox["G",
    FontSlant->"Italic"],
  " un dominio regular que contiene al punto ",
  StyleBox["a",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " y tomemos una bola ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " centrada en ",
  StyleBox["a",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " y de radio ",
  Cell[BoxData[
      \(TraditionalForm\`r > 0\)]],
  " de manera que est\[EAcute] contenida en ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ". Consideremos el dominio ",
  Cell[BoxData[
      \(TraditionalForm\`D = G\\B\)]],
  " que se obtiene quit\[AAcute]ndole a ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " la bola ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  ". Es claro que el dominio ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " no contiene ",
  StyleBox["a",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " y que ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]D = \[PartialD]B \[Union] \(\(\[PartialD]\
\)\(G\)\(\ \)\)\)]],
  ". La orientaci\[OAcute]n positiva en ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]G\)]],
  " es la misma respecto a ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " y respecto a ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " y viene dada por la normal exterior a ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ", mientras que la orientaci\[OAcute]n positiva en  ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]B\)]],
  " ",
  StyleBox["como parte de la frontera de",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`D = G\\B\)]],
  " es la dada por el vector normal que apunta hacia dentro de ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  ", es decir, la opuesta a su orientaci\[OAcute]n positiva como frontera de \
",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  ". En consecuencia tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{"0", "=", 
          RowBox[{
            RowBox[{"\[Integral]", 
              RowBox[{"\[Integral]", 
                RowBox[{\(\[Integral]\_D\), 
                  RowBox[{"div", " ", 
                    RowBox[{
                      StyleBox["E",
                        FontWeight->"Bold"], "(", 
                      StyleBox["x",
                        FontWeight->"Bold"], ")"}], 
                    RowBox[{"\[DifferentialD]", 
                      StyleBox["x",
                        FontWeight->"Bold"]}]}]}]}]}], 
            StyleBox["=",
              FontWeight->"Plain"], 
            RowBox[{
              RowBox[{
                StyleBox["\[Integral]",
                  FontWeight->"Plain"], 
                RowBox[{
                  SubscriptBox[
                    StyleBox["\[Integral]",
                      FontWeight->"Plain"], \(\[PartialD]D\)], 
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        StyleBox["E",
                          FontWeight->"Bold"], "(", 
                        StyleBox["x",
                          FontWeight->"Bold"], ")"}], " ", 
                      StyleBox[".",
                        FontWeight->"Bold"], 
                      StyleBox[" ",
                        FontWeight->"Bold"], 
                      RowBox[{
                        StyleBox["n",
                          FontWeight->"Bold"], "(", 
                        StyleBox["x",
                          FontWeight->"Bold"], 
                        ")"}]}], \(\[DifferentialD]S\)}]}]}], "=", 
              RowBox[{
                RowBox[{
                  StyleBox["\[Integral]",
                    FontWeight->"Plain"], 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["\[Integral]",
                        FontWeight->"Plain"], \(\[PartialD]G\)], 
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          StyleBox["E",
                            FontWeight->"Bold"], "(", 
                          StyleBox["x",
                            FontWeight->"Bold"], ")"}], " ", 
                        StyleBox[".",
                          FontWeight->"Bold"], 
                        StyleBox[" ",
                          FontWeight->"Bold"], 
                        RowBox[{
                          StyleBox["n",
                            FontWeight->"Bold"], "(", 
                          StyleBox["x",
                            FontWeight->"Bold"], 
                          ")"}]}], \(\[DifferentialD]S\)}]}]}], " ", "-", 
                RowBox[{
                  StyleBox["\[Integral]",
                    FontWeight->"Plain"], 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["\[Integral]",
                        FontWeight->"Plain"], \(\[PartialD]B\)], 
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          StyleBox["E",
                            FontWeight->"Bold"], "(", 
                          StyleBox["x",
                            FontWeight->"Bold"], ")"}], " ", 
                        StyleBox[".",
                          FontWeight->"Bold"], 
                        StyleBox[" ",
                          FontWeight->"Bold"], 
                        RowBox[{
                          StyleBox["n",
                            FontWeight->"Bold"], "(", 
                          StyleBox["x",
                            FontWeight->"Bold"], 
                          ")"}]}], \(\[DifferentialD]S\)}]}]}]}]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["de donde", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["\[Integral]",
            FontWeight->"Plain"], 
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Plain"], \(\[PartialD]G\)], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["E",
                    FontWeight->"Bold"], "(", 
                  StyleBox["x",
                    FontWeight->"Bold"], ")"}], " ", 
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox["n",
                    FontWeight->"Bold"], "(", 
                  StyleBox["x",
                    FontWeight->"Bold"], ")"}]}], \(\[DifferentialD]S\)}]}]}],
         " ", "=", 
        RowBox[{
          StyleBox["\[Integral]",
            FontWeight->"Plain"], 
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Plain"], \(\[PartialD]B\)], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["E",
                    FontWeight->"Bold"], "(", 
                  StyleBox["x",
                    FontWeight->"Bold"], ")"}], " ", 
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox["n",
                    FontWeight->"Bold"], "(", 
                  StyleBox["x",
                    FontWeight->"Bold"], 
                  ")"}]}], \(\[DifferentialD]S\)}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Pero la \[UAcute]ltima integral es inmediata porque para ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \[PartialD]B\)]],
  " se tiene que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["E",
              FontWeight->"Bold"], "(", 
            StyleBox["x",
              FontWeight->"Bold"], ")"}], " ", 
          StyleBox[".",
            FontWeight->"Bold"], " ", 
          RowBox[{
            StyleBox["n",
              FontWeight->"Bold"], "(", 
            StyleBox["x",
              FontWeight->"Bold"], ")"}]}], "=", 
        RowBox[{
          
          RowBox[{\(1\/\(4  \[Pi]\ \[Epsilon]\)\), \(\(\(\ \)\(Q\)\)\/r\^3\), 
            
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  StyleBox["x",
                    FontWeight->"Bold"], 
                  StyleBox["-",
                    FontWeight->"Plain"], 
                  StyleBox["a",
                    FontWeight->"Bold"]}], 
                StyleBox[")",
                  FontWeight->"Bold"]}], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              StyleBox[".",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox["n",
                  FontWeight->"Bold"], 
                StyleBox["(",
                  FontWeight->"Plain"], 
                StyleBox["x",
                  FontWeight->"Bold"], 
                StyleBox[")",
                  FontWeight->"Plain"]}]}]}], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            
            RowBox[{\(1\/\(4  \[Pi]\ \[Epsilon]\)\), \(\(\(\ \
\)\(Q\)\)\/r\^3\), 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["x",
                      FontWeight->"Bold"], 
                    StyleBox["-",
                      FontWeight->"Plain"], 
                    StyleBox["a",
                      FontWeight->"Bold"]}], 
                  StyleBox[")",
                    FontWeight->"Bold"]}], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                StyleBox[
                  FractionBox[
                    RowBox[{"(", 
                      RowBox[{
                        StyleBox["x",
                          FontWeight->"Bold"], 
                        StyleBox["-",
                          FontWeight->"Plain"], 
                        StyleBox["a",
                          FontWeight->"Bold"]}], 
                      StyleBox[")",
                        FontWeight->"Bold"]}], 
                    StyleBox["r",
                      FontWeight->"Plain"]],
                  FontWeight->"Bold"]}]}], 
            "=", \(\(1\/\(4  \[Pi]\ \[Epsilon]\)\) \(\(\ \
\)\(Q\)\)\/r\^2\)}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["luego", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["\[Integral]",
            FontWeight->"Plain"], 
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Plain"], \(\[PartialD]G\)], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["E",
                    FontWeight->"Bold"], "(", 
                  StyleBox["x",
                    FontWeight->"Bold"], ")"}], " ", 
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox["n",
                    FontWeight->"Bold"], "(", 
                  StyleBox["x",
                    FontWeight->"Bold"], ")"}]}], \(\[DifferentialD]S\)}]}]}],
         " ", "=", 
        RowBox[{
          RowBox[{\(1\/\(4  \[Pi]\ \[Epsilon]\)\), 
            RowBox[{
              StyleBox["\[Integral]",
                FontWeight->"Plain"], 
              RowBox[{
                SubscriptBox[
                  StyleBox["\[Integral]",
                    
                    FontWeight->
                      "Plain"], \(\[PartialD]B\)], \(\(\(\(\ \
\)\(Q\)\)\/r\^2\) \[DifferentialD]S\)}]}]}], 
          "=", \(\(1\/\(4  \[Pi]\ \[Epsilon]\)\) \(\(\(\ \)\(Q\)\)\/r\^2\) 
              4  \[Pi]\ r\^2 = \(\(\ \)\(Q\)\)\/\[Epsilon]\)}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Este resultado se generaliza inmediatamente para el campo \
el\[EAcute]ctrico producido por un n\[UAcute]mero finito, ",
  StyleBox["n",
    FontSlant->"Italic"],
  ",  de cargas puntuales ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(q\_j\)\(\ \)\)\)]],
  "situadas en los puntos ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["a",
              FontWeight->"Bold"], "j"], 
          "\[Element]", \(\[DoubleStruckCapitalR]\^3\)}], TraditionalForm]]],
  ". Dicho campo viene dado por la suma vectorial de los campos creados por \
cada carga"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(E \((x)\)\),
          FontWeight->"Bold",
          FontSlant->"Italic"], "=", 
        RowBox[{\(1\/\(4  \[Pi]\ \[Epsilon]\)\), 
          RowBox[{\(\(\[Sum]\+\(j = 1\)\)\&n\), 
            RowBox[{
              StyleBox[
                FractionBox[
                  RowBox[{
                    StyleBox["  ",
                      FontSlant->"Italic"], 
                    SubscriptBox[
                      StyleBox["q",
                        FontSlant->"Italic"], "j"]}], 
                  RowBox[{
                    StyleBox["||",
                      FontSlant->"Plain"], 
                    RowBox[{
                      StyleBox["x",
                        FontWeight->"Bold"], 
                      StyleBox["-",
                        FontWeight->"Plain"], 
                      SubscriptBox[
                        StyleBox["a",
                          FontWeight->"Bold"], "j"]}], 
                    SuperscriptBox[
                      StyleBox["||",
                        FontSlant->"Plain"], 
                      StyleBox["3",
                        FontSlant->"Plain"]]}]],
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["(",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["x",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox["-",
                    FontWeight->"Plain",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  SubscriptBox[
                    StyleBox["a",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "j"]}], 
                StyleBox[")",
                  FontWeight->"Plain",
                  FontSlant->"Italic"]}], "                  ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    StyleBox["x",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    "\[Element]", \(\[DoubleStruckCapitalR]\^3\)}], ",", 
                  RowBox[{
                    StyleBox["x",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "\[NotEqual]", 
                    SubscriptBox[
                      StyleBox["a",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox["j",
                        FontSlant->"Italic"]]}]}], ")"}]}]}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Se tiene que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"div", " ", 
            RowBox[{
              StyleBox["E",
                FontWeight->"Bold"], "(", 
              StyleBox["x",
                FontWeight->"Bold"], ")"}]}], "=", "0"}], TraditionalForm]]],
  " para todo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], 
            "\[Element]", \(\[DoubleStruckCapitalR]\^3\)}], ",", " ", 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "\[NotEqual]", 
            SubscriptBox[
              StyleBox["a",
                FontWeight->"Bold"], "j"]}]}], TraditionalForm]]],
  ". En consecuencia, el teorema de la divergencia nos dice que el flujo neto \
de ",
  StyleBox["E",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " a trav\[EAcute]s de cualquier superficie cerrada que no encierre a \
ninguno de los puntos ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            FontWeight->"Bold"], "j"], TraditionalForm]]],
  " es nulo. Mientras que si la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " encierra algunos de dichos puntos y es ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " la suma de las cargas que encierra se tiene que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["\[Integral]",
            FontWeight->"Plain"], 
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Plain"], "S"], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["E",
                    FontWeight->"Bold"], "(", 
                  StyleBox["x",
                    FontWeight->"Bold"], ")"}], " ", 
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox["n",
                    FontWeight->"Bold"], "(", 
                  StyleBox["x",
                    FontWeight->"Bold"], ")"}]}], \(\[DifferentialD]S\)}]}]}],
         " ", "=", \(Q\/\[Epsilon]\)}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Consideremos ahora que tenemos una distribuci\[OAcute]n continua de cargas \
en un dominio regular \[CapitalOmega] del espacio. Es decir, tenemos una \
funci\[OAcute]n continua",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[Rho] : \[CapitalOmega] \[Rule] \
\[DoubleStruckCapitalR]\)\)\)]],
  " llamada ",
  StyleBox["densidad de carga",
    FontSlant->"Italic"],
  " que se anula fuera de \[CapitalOmega] tal que la carga neta contenida en \
un conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`E \[Subset] \[CapitalOmega]\)]],
  " viene dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_E\), 
          RowBox[{
            RowBox[{"\[Rho]", "(", 
              StyleBox["x",
                FontWeight->"Bold"], ")"}], 
            RowBox[{"\[DifferentialD]", 
              StyleBox["x",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ". En este caso, la suma que corresponde a una distribuci\[OAcute]n finita \
de cargas se convierte en una integral y el campo viene dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["E",
            FontWeight->"Bold"], "(", 
          StyleBox["x",
            FontWeight->"Bold"], ")"}], "=", 
        RowBox[{\(1\/\(4  \[Pi]\ \[Epsilon]\)\), 
          RowBox[{\(\[Integral]\_\[CapitalOmega]\), 
            RowBox[{
              FractionBox[
                RowBox[{"\[Rho]", "(", 
                  StyleBox["y",
                    FontWeight->"Bold"], ")"}], 
                RowBox[{"||", 
                  RowBox[{
                    StyleBox["x",
                      FontWeight->"Bold"], "-", 
                    StyleBox["y",
                      FontWeight->"Bold"]}], \( || \^3\)}]], 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["x",
                    FontWeight->"Bold"], "-", 
                  StyleBox["y",
                    FontWeight->"Bold"]}], ")"}], 
              RowBox[{"\[DifferentialD]", 
                RowBox[{
                  StyleBox["y",
                    FontWeight->"Bold"], 
                  StyleBox[
                    RowBox[{
                      StyleBox["                ",
                        FontWeight->"Bold"], "     "}]], "(", 
                  RowBox[{
                    StyleBox["x",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    "\[Element]", \(\[DoubleStruckCapitalR]\^3\)}], 
                  ")"}]}]}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde se entiende que la integral de una funci\[OAcute]n vectorial es el \
vector formado por la integral de cada una de sus componentes. F\[IAcute]jate \
en que si ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], "\[Element]", "\[CapitalOmega]"}], 
        TraditionalForm]]],
  " el integrando no est\[AAcute] definido en ",
  StyleBox["x ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "pero se demuestra que la integral tiene sentido. ",
  "En este caso la ley de Gauss adopta la forma siguiente: si ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " es un dominio regular con frontera ",
  Cell[BoxData[
      \(TraditionalForm\`S = \[PartialD]D\)]],
  "se verifica que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["\[Integral]",
            FontWeight->"Plain"], 
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Plain"], "S"], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["E",
                    FontWeight->"Bold"], "(", 
                  StyleBox["x",
                    FontWeight->"Bold"], ")"}], " ", 
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox["n",
                    FontWeight->"Bold"], "(", 
                  StyleBox["x",
                    FontWeight->"Bold"], ")"}]}], \(\[DifferentialD]S\)}]}]}],
         " ", "=", 
        RowBox[{\(1\/\[Epsilon]\), 
          RowBox[{"\[Integral]", 
            RowBox[{"\[Integral]", 
              RowBox[{\(\[Integral]\_D\), 
                RowBox[{
                  RowBox[{"\[Rho]", "(", 
                    StyleBox["x",
                      FontWeight->"Bold"], ")"}], 
                  RowBox[{"\[DifferentialD]", 
                    StyleBox["x",
                      FontWeight->"Bold"]}]}]}]}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["Usando ahora el teorema de la divergencia tenemos", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["\[Integral]",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox["\[Integral]",
              FontWeight->"Plain"], 
            RowBox[{
              SubscriptBox[
                StyleBox["\[Integral]",
                  FontWeight->"Plain"], "D"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{"div", 
                      StyleBox["E",
                        FontWeight->"Bold"]}]], "(", 
                  StyleBox["x",
                    FontWeight->"Bold"], ")"}], " ", 
                RowBox[{
                  StyleBox["\[DifferentialD]",
                    FontWeight->"Plain"], 
                  StyleBox["x",
                    FontWeight->"Bold"]}]}]}]}]}], "=", 
        RowBox[{\(1\/\[Epsilon]\), 
          RowBox[{"\[Integral]", 
            RowBox[{"\[Integral]", 
              RowBox[{\(\[Integral]\_D\), 
                RowBox[{
                  RowBox[{"\[Rho]", "(", 
                    StyleBox["x",
                      FontWeight->"Bold"], ")"}], 
                  RowBox[{"\[DifferentialD]", 
                    StyleBox["x",
                      FontWeight->"Bold"]}]}]}]}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["o lo que es igual", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["\[Integral]",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox["\[Integral]",
              FontWeight->"Plain"], 
            RowBox[{
              SubscriptBox[
                StyleBox["\[Integral]",
                  FontWeight->"Plain"], "D"], 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      StyleBox[
                        RowBox[{"div", 
                          StyleBox["E",
                            FontWeight->"Bold"]}]], "(", 
                      StyleBox["x",
                        FontWeight->"Bold"], ")"}], "-", 
                    FractionBox[
                      RowBox[{"\[Rho]", "(", 
                        StyleBox["x",
                          FontWeight->"Bold"], ")"}], "\[Epsilon]"]}], ")"}], 
                
                RowBox[{"\[DifferentialD]", 
                  StyleBox["x",
                    FontWeight->"Bold"]}]}]}]}]}], "=", "0"}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Como esta igualdad tiene que ser v\[AAcute]lida para todo dominio regular \
",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  ", concluimos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox[
            RowBox[{"div", 
              StyleBox["E",
                FontWeight->"Bold"]}]], "(", 
          StyleBox["x",
            FontWeight->"Bold"], ")"}], "=", 
        FractionBox[
          RowBox[{"\[Rho]", "(", 
            StyleBox["x",
              FontWeight->"Bold"], ")"}], "\[Epsilon]"]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Es sabido que el campo el\[EAcute]ctrico es conservativo. En el caso que nos \
ocupa se verifica que la funci\[OAcute]n\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"V", "(", 
          StyleBox["x",
            FontWeight->"Bold"], ")"}], "=", 
        RowBox[{\(1\/\(4  \[Pi]\ \[Epsilon]\)\), 
          RowBox[{\(\[Integral]\_\[CapitalOmega]\), 
            RowBox[{
              FractionBox[
                RowBox[{"\[Rho]", "(", 
                  StyleBox["y",
                    FontWeight->"Bold"], ")"}], 
                RowBox[{"||", 
                  RowBox[{
                    StyleBox["x",
                      FontWeight->"Bold"], "-", 
                    StyleBox["y",
                      FontWeight->"Bold"]}], "||"}]], 
              RowBox[{"\[DifferentialD]", 
                RowBox[{
                  StyleBox["y",
                    FontWeight->"Bold"], 
                  StyleBox[
                    RowBox[{
                      StyleBox["                ",
                        FontWeight->"Bold"], "     "}]], "(", 
                  RowBox[{
                    StyleBox["x",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    "\[Element]", \(\[DoubleStruckCapitalR]\^3\)}], 
                  ")"}]}]}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "es una funci\[OAcute]n potencial para ",
  StyleBox["E",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", es decir, se verifica la igualdad "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["E",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], 
        "=", \(\(-\[Del]\(V(x, y, 
                z)\)\) = \(-\((\(\[PartialD]V\/\[PartialD]\ x\) \((x, y, 
                  z)\), \(\[PartialD]V\/\[PartialD]\ y\) \((x, y, 
                  z)\), \(\[PartialD]V\/\[PartialD]\ z\) \((x, y, 
                  z)\))\)\)\)}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["En consecuencia", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\(div(\[Del]V)\) \((x, y, z)\)\), "=", 
        RowBox[{"-", 
          FormBox[\(\(\[Rho](x, y, z)\)\/\[Epsilon]\),
            "TraditionalForm"]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "que es la ",
  StyleBox["ecuaci\[OAcute]n de Poisson",
    FontWeight->"Bold"],
  ". Un sencillo c\[AAcute]lculo permite comprobar que para cualquier campo \
escalar ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^2\)]],
  "se verifica que"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[\(div\ \((\[Del]\ f)\) \((x, y, 
              z)\) = \(\[PartialD]\^2 f\/\[PartialD]x\^2\) \((x, y, 
                z)\) + \(\[PartialD]\^2 f\/\[PartialD]y\^2\) \((x, y, 
                z)\) + \(\[PartialD]\^2 f\/\[PartialD]z\^2\) \((x, y, z)\)\),
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["La expresi\[OAcute]n", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{" ", 
        RowBox[{\(\[CapitalDelta]\ \(f(x, y, z)\)\), "=", 
          FormBox[
            
            FormBox[\(\(\[PartialD]\^2 f\/\[PartialD]x\^2\) \((x, y, 
                    z)\) + \(\[PartialD]\^2 f\/\[PartialD]y\^2\) \((x, y, 
                    z)\) + \(\[PartialD]\^2 f\/\[PartialD]z\^2\) \((x, y, 
                    z)\)\),
              "TraditionalForm"],
            "TraditionalForm"]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "se llama ",
  StyleBox["laplaciana",
    FontWeight->"Bold"],
  " del campo escalar ",
  StyleBox["f. ",
    FontSlant->"Italic"],
  "El operador",
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] : \ 
          f \[Rule] \[CapitalDelta]\ f\)]],
  " se llama ",
  StyleBox["operador de Laplace",
    FontWeight->"Bold"],
  ". La ecuaci\[OAcute]n de Poisson para el potencial el\[EAcute]ctrico suele \
escribirse en la forma condensada ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\ V = \(-\[Rho]\)/\[Epsilon]\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Funciones arm\[OAcute]nicas", "Section"],

Cell[TextData[{
  "Sea ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  un campo escalar de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^2\)]],
  " definido en un abierto ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalOmega]", "\[Subset]", 
          FormBox[\(\[DoubleStruckCapitalR]\^3\),
            "TraditionalForm"]}], TraditionalForm]]],
  ". Se dice que ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "es",
  " una funci\[OAcute]n arm\[OAcute]nica en \[CapitalOmega] si para todo ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Element] \[CapitalOmega]\)]],
  " se verifica que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          
          FormBox[\(\(\[PartialD]\^2 f\/\[PartialD]x\^2\) \((x, y, 
                  z)\) + \(\[PartialD]\^2 f\/\[PartialD]y\^2\) \((x, y, 
                  z)\) + \(\[PartialD]\^2 f\/\[PartialD]z\^2\) \((x, y, 
                  z)\)\),
            "TraditionalForm"],
          "TraditionalForm"], "=", "0"}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Dicho en otras palabras, las funciones arm\[OAcute]nicas en \
\[CapitalOmega] son las soluciones de la ",
  StyleBox["ecuaci\[OAcute]n de Laplace",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\ \(f(x, y, z)\) = 0\)]],
  " en \[CapitalOmega]."
}], "Text"],

Cell[TextData[{
  "Es f\[AAcute]cil comprobar que la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " definida para todo ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[NotEqual] \ \((0, 0, 0)\)\)]],
  " por"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`f(x, y, z) = \(1\/\(\(||\)\((x, y, z)\)\(||\)\) = 
        1\/\@\(x\^2 + y\^2 + z\^2\)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "es arm\[OAcute]nica en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\\{\((0, 0, 0)\)}\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "El teorema de la divergencia para un campo conservativo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], 
          "=", \(-\[Del]\(f(x, y, z)\)\)}], TraditionalForm]]],
  " adopta la forma"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Integral]", 
          RowBox[{\(\[Integral]\_\(\[PartialD]D\)\), 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["F",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox["(",
                    FontWeight->"Plain",
                    FontSlant->"Italic"], 
                  StyleBox[\(x, y, z\),
                    FontWeight->"Plain",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontWeight->"Plain",
                    FontSlant->"Italic"]}], 
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                StyleBox["n",
                  FontWeight->"Bold"]}], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              StyleBox[\(\[DifferentialD]S\),
                FontWeight->"Plain"]}]}]}], 
        StyleBox[" ",
          FontWeight->"Plain"], 
        StyleBox["=",
          FontWeight->"Plain"], 
        RowBox[{
          RowBox[{
            StyleBox["-",
              FontWeight->"Plain"], 
            RowBox[{
              StyleBox["\[Integral]",
                FontWeight->"Plain"], 
              RowBox[{
                SubscriptBox[
                  StyleBox["\[Integral]",
                    FontWeight->"Plain"], \(\[PartialD]D\)], 
                RowBox[{
                  RowBox[{\(\[Del]\ \(f(x, y, z)\)\), " ", 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    StyleBox["n",
                      FontWeight->"Bold"]}], 
                  StyleBox[" ",
                    FontWeight->"Bold"], \(\[DifferentialD]S\)}]}]}]}], " ", 
          "=", 
          
          RowBox[{\(-\(\[Integral]\(\[Integral]\_\(\[PartialD]D\)\(\[PartialD]\
\ f\/\[PartialD]n\) \((x, y, z)\) \[DifferentialD]S\)\)\), "=", 
            RowBox[{
              RowBox[{"\[Integral]", 
                RowBox[{"\[Integral]", 
                  RowBox[{\(\[Integral]\_D\), 
                    RowBox[{"div", " ", 
                      RowBox[{
                        StyleBox["F",
                          FontWeight->"Bold"], "(", \(x, y, z\), 
                        ")"}], \(\[DifferentialD]\((x, y, z)\)\)}]}]}]}], 
              "=", \(\(-\(\[Integral]\(\[Integral]\(\[Integral]\_D 
                          div \[Del]\(f(x, y, z)\) \(d(x, y, 
                            z)\)\)\)\)\) = \(-\(\[Integral]\(\[Integral]\(\
\[Integral]\_D \[CapitalDelta]\ \(f(x, y, 
                            z)\) \[DifferentialD]\((x, y, 
                              z)\)\)\)\)\)\)}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["esto es", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[Integral]\(\[Integral]\_\(\[PartialD]D\)\(\[PartialD]\
\ f\/\[PartialD]n\) \((x, y, 
              z)\) \[DifferentialD]S\) = \
\[Integral]\(\[Integral]\(\[Integral]\_D \[CapitalDelta]\ \(f(x, y, 
                z)\) \[DifferentialD]\((x, y, z)\)\)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde hemos tenido en cuenta que el producto escalar del gradiente de un \
campo escalar por un vector unitario es igual a la derivada de dicho campo \
escalar en la direcci\[OAcute]n dada por dicho vector, por ello ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Del]\(f(x, y, z)\)\), " ", 
            StyleBox[".",
              FontWeight->"Bold"], " ", 
            StyleBox["n",
              FontWeight->"Bold"]}], " ", "=", 
          FormBox[\(\(\[PartialD]\ f\/\[PartialD]n\) \((x, y, z)\)\),
            "TraditionalForm"]}], TraditionalForm]]],
  " es la derivada de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " en la direcci\[OAcute]n de la normal exterior a la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]D\)]],
  "en dicho punto. En particular, deducimos que para toda funci\[OAcute]n  ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "arm\[OAcute]nica en un abierto que contenga al dominio regular ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " y a su frontera se verifica que"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[Integral]\(\[Integral]\_\(\[PartialD]D\)\(\[PartialD]\
\ f\/\[PartialD]n\) \((x, y, z)\) \[DifferentialD]S\) = 0\)], "Text",
  TextAlignment->Center],

Cell[CellGroupData[{

Cell["Ejercicios", "Exercise"],

Cell["\<\
Los ejercicios de este tema son los propuestos en el libro de James Stewart, \
C\[AAcute]lculo Multivariable 4\.aa Edici\[OAcute]n, en las secciones 16.8 \
(ejercicios 2-6, 7-10, 13-15 de la p\[AAcute]gina 1109) y 16.9 (ejercicios \
3-6, 7-16, 19-28 p\[AAcute]ginas 1116 y 1117).\
\>", "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Teoremas de Stokes y de Gauss. Funciones arm\[OAcute]nicas"], 
        "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Teoremas de Stokes y de Gauss. Funciones arm\[OAcute]nicas"], 
        "Header"]}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.32.1"->{
    Cell[2299, 74, 85, 2, 70, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"],
    Cell[2387, 78, 86, 2, 70, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"]},
  "S5.29.1"->{
    Cell[18019, 400, 89, 2, 93, "Input",
      InitializationCell->True,
      CellTags->"S5.29.1"]},
  "S5.16.1"->{
    Cell[18111, 404, 94, 2, 93, "Input",
      InitializationCell->True,
      CellTags->"S5.16.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.32.1", 146423, 4285},
  {"S5.29.1", 146637, 4292},
  {"S5.16.1", 146754, 4296}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 82, 3, 174, "Title"],
Cell[1839, 56, 164, 5, 102, "Author"],

Cell[CellGroupData[{
Cell[2028, 65, 41, 0, 93, "Section"],
Cell[2072, 67, 224, 5, 150, "Input",
  InitializationCell->True],
Cell[2299, 74, 85, 2, 70, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[2387, 78, 86, 2, 70, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[2476, 82, 784, 16, 261, "Input",
  InitializationCell->True],
Cell[3263, 100, 949, 16, 331, "Input",
  InitializationCell->True],
Cell[4215, 118, 252, 5, 159, "Input",
  InitializationCell->True],
Cell[4470, 125, 242, 5, 139, "Input",
  InitializationCell->True],
Cell[4715, 132, 2138, 40, 849, "Input",
  InitializationCell->True],
Cell[6856, 174, 2178, 41, 789, "Input",
  InitializationCell->True],
Cell[9037, 217, 2467, 46, 813, "Input",
  InitializationCell->True],
Cell[11507, 265, 2195, 42, 657, "Input",
  InitializationCell->True],
Cell[13705, 309, 2161, 42, 630, "Input",
  InitializationCell->True],
Cell[15869, 353, 91, 2, 93, "Input",
  InitializationCell->True],
Cell[15963, 357, 2053, 41, 379, "Input",
  InitializationCell->True],
Cell[18019, 400, 89, 2, 93, "Input",
  InitializationCell->True,
  CellTags->"S5.29.1"],
Cell[18111, 404, 94, 2, 93, "Input",
  InitializationCell->True,
  CellTags->"S5.16.1"],
Cell[18208, 408, 79, 2, 93, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[18324, 415, 36, 0, 61, "Section"],
Cell[18363, 417, 650, 12, 119, "Text"],
Cell[19016, 431, 1141, 33, 145, "Text"],
Cell[20160, 466, 1315, 41, 119, "Text"],
Cell[21478, 509, 6579, 221, 353, "Text"],
Cell[28060, 732, 535, 12, 93, "Text"],
Cell[28598, 746, 56, 1, 72, "Input"],
Cell[28657, 749, 56, 1, 72, "Input"],
Cell[28716, 752, 46, 1, 72, "Input"],
Cell[28765, 755, 44, 1, 72, "Input"],
Cell[28812, 758, 227, 4, 67, "Text"],
Cell[29042, 764, 1110, 37, 93, "Text"],
Cell[30155, 803, 1232, 35, 70, "Text"],
Cell[31390, 840, 421, 15, 41, "Text"],
Cell[31814, 857, 539, 14, 35, "Text"],
Cell[32356, 873, 129, 5, 41, "Text"],
Cell[32488, 880, 1520, 40, 89, "Text"],
Cell[34011, 922, 1491, 39, 171, "Text"],
Cell[35505, 963, 2149, 59, 60, "Text"],
Cell[37657, 1024, 1180, 34, 47, "Text"],
Cell[38840, 1060, 433, 8, 176, "Input"],
Cell[39276, 1070, 30, 0, 41, "Text"],
Cell[39309, 1072, 1923, 57, 89, "Text"],
Cell[41235, 1131, 499, 17, 41, "Text"],
Cell[41737, 1150, 225, 5, 98, "Input"],
Cell[41965, 1157, 58, 0, 41, "Text"],
Cell[42026, 1159, 70, 1, 72, "Input"],
Cell[42099, 1162, 44, 0, 41, "Text"],
Cell[42146, 1164, 1837, 43, 228, "Input"],
Cell[43986, 1209, 642, 22, 42, "Text"],
Cell[44631, 1233, 102, 2, 72, "Input"],
Cell[44736, 1237, 43, 0, 41, "Text"],
Cell[44782, 1239, 3231, 88, 89, "Text"],
Cell[48016, 1329, 295, 8, 42, "Text"],
Cell[48314, 1339, 2322, 65, 60, "Text"],
Cell[50639, 1406, 450, 14, 49, "Text"],
Cell[51092, 1422, 105, 2, 94, "Input"],
Cell[51200, 1426, 61, 1, 94, "Input"],
Cell[51264, 1429, 45, 0, 41, "Text"],
Cell[51312, 1431, 2005, 58, 60, "Text"],
Cell[53320, 1491, 86, 2, 41, "Text"],
Cell[53409, 1495, 1564, 45, 145, "Text"],
Cell[54976, 1542, 1883, 55, 60, "Text"],
Cell[56862, 1599, 837, 25, 42, "Text"],
Cell[57702, 1626, 92, 1, 72, "Input"],
Cell[57797, 1629, 1715, 48, 61, "Text"],
Cell[59515, 1679, 2746, 73, 61, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[62298, 1757, 44, 0, 93, "Section"],
Cell[62345, 1759, 2896, 86, 341, "Text"],
Cell[65244, 1847, 487, 14, 35, "Text"],
Cell[65734, 1863, 1458, 51, 121, "Text"],
Cell[67195, 1916, 679, 23, 68, "Text"],
Cell[67877, 1941, 1623, 44, 70, "Text"],
Cell[69503, 1987, 780, 19, 120, "Text"],
Cell[70286, 2008, 289, 8, 41, "Text"],
Cell[70578, 2018, 1315, 36, 63, "Text"],
Cell[71896, 2056, 1948, 54, 97, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[73881, 2115, 120, 2, 93, "Section"],
Cell[74004, 2119, 2363, 57, 325, "Text"],
Cell[76370, 2178, 47, 1, 72, "Input"],
Cell[76420, 2181, 6138, 178, 339, "Text"],
Cell[82561, 2361, 1461, 43, 57, "Text"],
Cell[84025, 2406, 48, 0, 41, "Text"],
Cell[84076, 2408, 1733, 45, 58, "Text"],
Cell[85812, 2455, 1042, 31, 120, "Text"],
Cell[86857, 2488, 819, 23, 60, "Text"],
Cell[87679, 2513, 458, 15, 67, "Text"],
Cell[88140, 2530, 563, 16, 60, "Text"],
Cell[88706, 2548, 200, 7, 42, "Text"],
Cell[88909, 2557, 1008, 31, 60, "Text"],
Cell[89920, 2590, 227, 8, 41, "Text"],
Cell[90150, 2600, 993, 29, 60, "Text"],
Cell[91146, 2631, 27, 0, 41, "Text"],
Cell[91176, 2633, 1645, 45, 60, "Text"],
Cell[92824, 2680, 57, 0, 41, "Text"],
Cell[92884, 2682, 535, 15, 57, "Text"],
Cell[93422, 2699, 338, 6, 67, "Text"],
Cell[93763, 2707, 1244, 42, 157, "Text"],
Cell[95010, 2751, 444, 10, 61, "Text"],
Cell[95457, 2763, 589, 21, 67, "Text"],
Cell[96049, 2786, 2516, 58, 162, "Text"],
Cell[98568, 2846, 1241, 36, 145, "Text"],
Cell[99812, 2884, 709, 19, 62, "Text"],
Cell[100524, 2905, 268, 8, 41, "Text"],
Cell[100795, 2915, 312, 8, 58, "Text"],
Cell[101110, 2925, 716, 20, 131, "Text"],
Cell[101829, 2947, 299, 8, 58, "Text"],
Cell[102131, 2957, 857, 25, 93, "Text"],
Cell[102991, 2984, 498, 16, 79, "Text"],
Cell[103492, 3002, 2082, 60, 60, "Text"],
Cell[105577, 3064, 3794, 124, 305, "Text"],
Cell[109374, 3190, 3836, 94, 60, "Text"],
Cell[113213, 3286, 24, 0, 41, "Text"],
Cell[113240, 3288, 1773, 52, 60, "Text"],
Cell[115016, 3342, 180, 5, 41, "Text"],
Cell[115199, 3349, 2946, 86, 64, "Text"],
Cell[118148, 3437, 21, 0, 41, "Text"],
Cell[118172, 3439, 1503, 42, 60, "Text"],
Cell[119678, 3483, 624, 18, 67, "Text"],
Cell[120305, 3503, 2732, 72, 91, "Text"],
Cell[123040, 3577, 1378, 44, 95, "Text"],
Cell[124421, 3623, 936, 27, 60, "Text"],
Cell[125360, 3652, 1064, 27, 120, "Text"],
Cell[126427, 3681, 1532, 41, 62, "Text"],
Cell[127962, 3724, 776, 22, 94, "Text"],
Cell[128741, 3748, 1362, 39, 60, "Text"],
Cell[130106, 3789, 65, 0, 41, "Text"],
Cell[130174, 3791, 1345, 38, 60, "Text"],
Cell[131522, 3831, 33, 0, 41, "Text"],
Cell[131558, 3833, 1140, 32, 61, "Text"],
Cell[132701, 3867, 178, 6, 41, "Text"],
Cell[132882, 3875, 449, 15, 58, "Text"],
Cell[133334, 3892, 143, 3, 41, "Text"],
Cell[133480, 3897, 1257, 33, 62, "Text"],
Cell[134740, 3932, 178, 6, 42, "Text"],
Cell[134921, 3940, 469, 11, 61, "Text"],
Cell[135393, 3953, 31, 0, 41, "Text"],
Cell[135427, 3955, 247, 6, 58, "Text"],
Cell[135677, 3963, 329, 12, 67, "Text"],
Cell[136009, 3977, 371, 7, 65, "Text"],
Cell[136383, 3986, 36, 0, 41, "Text"],
Cell[136422, 3988, 507, 12, 65, "Text"],
Cell[136932, 4002, 614, 21, 67, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[137583, 4028, 46, 0, 93, "Section"],
Cell[137632, 4030, 633, 21, 67, "Text"],
Cell[138268, 4053, 435, 11, 65, "Text"],
Cell[138706, 4066, 318, 9, 41, "Text"],
Cell[139027, 4077, 248, 8, 41, "Text"],
Cell[139278, 4087, 162, 3, 64, "Text"],
Cell[139443, 4092, 153, 5, 41, "Text"],
Cell[139599, 4099, 328, 10, 41, "Text"],
Cell[139930, 4111, 2924, 75, 112, "Text"],
Cell[142857, 4188, 23, 0, 41, "Text"],
Cell[142883, 4190, 327, 6, 61, "Text"],
Cell[143213, 4198, 1161, 30, 124, "Text"],
Cell[144377, 4230, 188, 3, 61, "Text"],

Cell[CellGroupData[{
Cell[144590, 4237, 30, 0, 68, "Exercise"],
Cell[144623, 4239, 311, 5, 67, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

